/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta.command;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadataHandler;
import org.apache.deltaspike.partialbean.impl.PartialBeanProxyFactory;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxy;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInterceptorLookup;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;

public class RepositoryRefreshAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(RepositoryRefreshAgent.class);
    public static boolean reloadFlag = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshHandler(ClassLoader appClassLoader, String repoClassName, List repositoryProxies) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Map cache;
            Thread.currentThread().setContextClassLoader(appClassLoader);
            Class<?> repoClass = appClassLoader.loadClass(repoClassName);
            RepositoryMetadataHandler handler = RepositoryRefreshAgent.getInstance(RepositoryMetadataHandler.class);
            if (handler != null) {
                ReflectionHelper.invoke(handler, handler.getClass(), "$$ha$reinitialize", new Class[]{Class.class}, repoClass);
            } else {
                LOGGER.debug("{} bean not found.", RepositoryMetadataHandler.class.getName());
            }
            Method[] delegateMethods = PartialBeanProxyFactory.getInstance().getDelegateMethods(repoClass);
            for (Object proxyObject : repositoryProxies) {
                if (!(proxyObject instanceof DeltaSpikeProxy)) continue;
                ((DeltaSpikeProxy)proxyObject).setDelegateMethods(delegateMethods);
            }
            DeltaSpikeProxyInterceptorLookup lookup = RepositoryRefreshAgent.getInstance(DeltaSpikeProxyInterceptorLookup.class);
            if (lookup != null && (cache = (Map)ReflectionHelper.get(lookup, "cache")) != null) {
                cache.clear();
            }
            LOGGER.info("Deltaspike repository {} refreshed.", repoClassName);
            reloadFlag = true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Repository class '{}' not found.", repoClassName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    public static <T> T getInstance(Class<T> beanClass) {
        BeanManager beanManager = CDI.current().getBeanManager();
        Bean<T> bean = RepositoryRefreshAgent.resolve(beanManager, beanClass);
        return RepositoryRefreshAgent.getInstance(beanManager, bean);
    }

    private static <T> Bean<T> resolve(BeanManager beanManager, Class<T> beanClass) {
        Set beans = beanManager.getBeans(beanClass, new Annotation[0]);
        for (Bean bean : beans) {
            if (bean.getBeanClass() != beanClass) continue;
            return beanManager.resolve(Collections.singleton(bean));
        }
        return beanManager.resolve(beans);
    }

    private static <T> T getInstance(BeanManager beanManager, Bean<T> bean) {
        Context context = beanManager.getContext(bean.getScope());
        return (T)context.get(bean);
    }
}

