/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.deltaspike_jakarta.DeltaSpikeJakartaPlugin;
import org.hotswap.agent.util.PluginManagerInvoker;

public class PartialBeanExtensionTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PartialBeanExtensionTransformer.class);

    @OnClassLoadEvent(classNameRegexp="org.apache.deltaspike.partialbean.impl.PartialBeanBindingExtension")
    public static void patchPartialBeanBindingExtension(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        if (!HaCdiCommons.isJakarta(classPool)) {
            return;
        }
        CtMethod init = ctClass.getDeclaredMethod("init");
        init.insertAfter(PluginManagerInvoker.buildInitializePlugin(DeltaSpikeJakartaPlugin.class));
        LOGGER.debug("org.apache.deltaspike.partialbean.impl.PartialBeanBindingExtension enhanced with plugin initialization.", new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp="org.apache.deltaspike.proxy.api.DeltaSpikeProxyBeanConfigurator")
    public static void patchDeltaSpikeProxyBeanConfigurator(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        if (!HaCdiCommons.isJakarta(classPool)) {
            return;
        }
        CtMethod createPartialBeanMethod = ctClass.getDeclaredMethod("create");
        createPartialBeanMethod.insertAfter("if ($_ != null && " + PluginManager.class.getName() + ".getInstance().isPluginInitialized(\"" + DeltaSpikeJakartaPlugin.class.getName() + "\", this.targetClass.getClassLoader())) {" + PluginManagerInvoker.buildCallPluginMethod(DeltaSpikeJakartaPlugin.class, "registerPartialBean", "this.targetClass", "java.lang.Class") + PluginManagerInvoker.buildCallPluginMethod(DeltaSpikeJakartaPlugin.class, "registerRepoProxy", "$_", "java.lang.Object", "this.targetClass", "java.lang.Class") + "}return $_;");
        LOGGER.debug("org.apache.deltaspike.proxy.api.DeltaSpikeProxyBeanConfigurator patched.", new Object[0]);
    }
}

