/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.jersey1;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.AnnotationHelper;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;

@Plugin(name="Jersey1", description="Jersey1 framework plugin - this does not handle HK2 changes", testedVersions={"1.18.3"}, expectedVersions={"1.x"})
public class Jersey1Plugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(Jersey1Plugin.class);
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    Set<Object> registeredJerseyContainers = Collections.newSetFromMap(new WeakHashMap());
    Set<Class<?>> allRegisteredClasses = Collections.newSetFromMap(new WeakHashMap());
    private Command reloadJerseyContainers = new Command(){

        @Override
        public void executeCommand() {
            try {
                Class containerClass = Jersey1Plugin.this.resolveClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                Method reloadMethod = containerClass.getDeclaredMethod("reload", new Class[0]);
                for (Object jerseyContainer : Jersey1Plugin.this.registeredJerseyContainers) {
                    reloadMethod.invoke(jerseyContainer, new Object[0]);
                }
                LOGGER.info("Reloaded Jersey Containers", new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Error reloading Jersey Container.", e, new Object[0]);
            }
        }
    };

    @OnClassLoadEvent(classNameRegexp="com.sun.jersey.spi.container.servlet.ServletContainer")
    public static void jerseyServletCallInitialized(CtClass ctClass, ClassPool classPool) throws NotFoundException, CannotCompileException {
        CtMethod init = ctClass.getDeclaredMethod("init", new CtClass[]{classPool.get("com.sun.jersey.spi.container.servlet.WebConfig")});
        init.insertBefore(PluginManagerInvoker.buildInitializePlugin(Jersey1Plugin.class));
        LOGGER.info("com.sun.jersey.spi.container.servlet.WebConfig enhanced with plugin initialization.", new Object[0]);
        String registerThis = PluginManagerInvoker.buildCallPluginMethod(Jersey1Plugin.class, "registerJerseyContainer", "this", "java.lang.Object", "this.webComponent.getResourceConfig()", "java.lang.Object");
        init.insertAfter(registerThis);
    }

    public void registerJerseyContainer(Object jerseyContainer, Object resourceConfig) {
        try {
            Class<?> resourceConfigClass = this.resolveClass("com.sun.jersey.api.core.ResourceConfig");
            LOGGER.info("Jersey1 plugin - registerJerseyContainer : " + jerseyContainer.getClass().getName(), new Object[0]);
            Set<Class<?>> containerClasses = this.getContainerClasses(resourceConfigClass, resourceConfig);
            this.registeredJerseyContainers.add(jerseyContainer);
            this.allRegisteredClasses.addAll(containerClasses);
            LOGGER.debug("registerJerseyContainer : finished", new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Error registering Jersey Container.", e, new Object[0]);
        }
    }

    private Set<Class<?>> getContainerClasses(Class<?> resourceConfigClass, Object resourceConfig) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Set rootResourceClasses;
        Set<Class<?>> containerClasses = Collections.newSetFromMap(new WeakHashMap());
        Set providerClasses = (Set)ReflectionHelper.invoke(resourceConfig, resourceConfigClass, "getProviderClasses", new Class[0], new Object[0]);
        if (providerClasses != null) {
            containerClasses.addAll(providerClasses);
        }
        if ((rootResourceClasses = (Set)ReflectionHelper.invoke(resourceConfig, resourceConfigClass, "getRootResourceClasses", new Class[0], new Object[0])) != null) {
            containerClasses.addAll(rootResourceClasses);
        }
        return containerClasses;
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void invalidate(CtClass ctClass, Class original) throws Exception {
        if (this.allRegisteredClasses.contains(original)) {
            this.scheduler.scheduleCommand(this.reloadJerseyContainers);
        } else if (AnnotationHelper.hasAnnotation(original, "javax.ws.rs.Path") || AnnotationHelper.hasAnnotation(ctClass, "javax.ws.rs.Path")) {
            this.allRegisteredClasses.add(original);
            this.scheduler.scheduleCommand(this.reloadJerseyContainers);
        }
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }
}

