/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.mojarra.command;

import org.hotswap.agent.command.Command;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;

public class ReloadManagedBeanCommand
implements Command {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ReloadManagedBeanCommand.class);
    private CtClass beanCtClass;
    private Class<?> beanClass;
    private ClassLoader classLoader;

    public ReloadManagedBeanCommand(Class<?> beanClass, ClassLoader classLoader) {
        this.beanClass = beanClass;
        this.classLoader = classLoader;
    }

    public ReloadManagedBeanCommand(CtClass beanCtClass, ClassLoader classLoader) {
        this.beanCtClass = beanCtClass;
        this.classLoader = classLoader;
    }

    @Override
    public void executeCommand() {
        try {
            Class<?> beanClass = this.getBeanClass();
            if (this.isBeanClassLoadedBefore()) {
                LOGGER.info("Reloading managed bean: {}", beanClass.getName());
            } else {
                LOGGER.info("Registering new managed bean: {}", beanClass.getName());
            }
            Class<?> beanResolverClass = this.resolveClass("com.sun.faces.mgbean.BeanManager");
            ReflectionHelper.invoke(null, beanResolverClass, "addToDirtyBeans", new Class[]{Class.class}, beanClass);
        }
        catch (Exception ex) {
            LOGGER.info("Unable to reload managed bean. Reason: {}", ex.getMessage(), ex);
        }
    }

    private boolean isBeanClassLoadedBefore() {
        return this.beanClass != null;
    }

    private Class<?> getBeanClass() throws ClassNotFoundException, CannotCompileException {
        if (!this.isBeanClassLoadedBefore()) {
            return this.beanCtClass.toClass(this.classLoader);
        }
        return this.beanClass;
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.classLoader);
    }
}

