/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.mybatisplus;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.ReflectionCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.mybatisplus.MyBatisPlusRefreshCommands;
import org.hotswap.agent.plugin.mybatisplus.proxy.ConfigurationPlusProxy;
import org.hotswap.agent.plugin.mybatisplus.proxy.SpringMybatisPlusConfigurationProxy;
import org.hotswap.agent.plugin.mybatisplus.transformers.MyBatisPlusTransformers;

@Plugin(name="MyBatisPlus", description="Reload MyBatis Plus configuration after configuration create/change.", testedVersions={"All versions between 3.2.0 and 3.5.7"}, expectedVersions={"3.5.7"}, supportClass={MyBatisPlusTransformers.class})
public class MyBatisPlusPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(MyBatisPlusPlugin.class);
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    Map<String, Object> configurationMap = new HashMap<String, Object>();
    Command reloadConfigurationCommand = new ReflectionCommand((Object)this, MyBatisPlusRefreshCommands.class.getName(), "reloadConfiguration");

    @Init
    public void init(PluginConfiguration pluginConfiguration) {
        LOGGER.info("MyBatisPlus plugin initialized.", new Object[0]);
    }

    public void registerConfigurationFile(String configFile, Object configObject) {
        if (configFile != null && !this.configurationMap.containsKey(configFile)) {
            LOGGER.debug("MyBatisPlugin - configuration file registered : {}", configFile);
            this.configurationMap.put(configFile, configObject);
        }
    }

    @OnResourceFileEvent(path="/", filter=".*.xml", events={FileEvent.MODIFY})
    public void registerResourceListeners(URL url) throws URISyntaxException {
        for (String s : this.configurationMap.keySet()) {
            LOGGER.trace(s, new Object[0]);
        }
        if (this.configurationMap.containsKey(Paths.get(url.toURI()).toFile().getAbsolutePath())) {
            this.refresh(500);
        }
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void registerClassListeners(Class<?> clazz) {
        LOGGER.debug("Ready to schedule MybatisPlus reload for class '{}' in classLoader {}", clazz, this.appClassLoader);
        if (ConfigurationPlusProxy.isMybatisEntity(clazz) || SpringMybatisPlusConfigurationProxy.isMybatisPlusEntity(clazz)) {
            LOGGER.debug("Scheduling MybatisPlus reload for class '{}' in classLoader {}", clazz, this.appClassLoader);
            this.refresh(500);
        }
    }

    private void refresh(int timeout) {
        this.scheduler.scheduleCommand(this.reloadConfigurationCommand, timeout);
    }
}

