/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.mybatisplus.proxy;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisXMLConfigBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.hotswap.agent.javassist.util.proxy.MethodHandler;
import org.hotswap.agent.javassist.util.proxy.ProxyFactory;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.mybatis.proxy.SpringMybatisConfigurationProxy;
import org.hotswap.agent.plugin.mybatisplus.transformers.MybatisPlusConfigurationCaller;
import org.hotswap.agent.util.ReflectionHelper;

public class ConfigurationPlusProxy {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ConfigurationPlusProxy.class);
    private static Map<MybatisXMLConfigBuilder, ConfigurationPlusProxy> proxiedConfigurations = new HashMap<MybatisXMLConfigBuilder, ConfigurationPlusProxy>();
    private MybatisXMLConfigBuilder configBuilder;
    private MybatisConfiguration configuration;
    private MybatisConfiguration proxyInstance;

    public static ConfigurationPlusProxy getWrapper(MybatisXMLConfigBuilder configBuilder) {
        if (SpringMybatisConfigurationProxy.runningBySpringMybatis()) {
            LOGGER.debug("MyBatis runs in MyBatis-Spring mode, so there is no need to cache configuration-related data", new Object[0]);
            return new ConfigurationPlusProxy(configBuilder);
        }
        LOGGER.info("configBuilder add", new Object[0]);
        if (!proxiedConfigurations.containsKey(configBuilder)) {
            proxiedConfigurations.put(configBuilder, new ConfigurationPlusProxy(configBuilder));
        }
        return proxiedConfigurations.get(configBuilder);
    }

    public static void refreshProxiedConfigurations() {
        LOGGER.info("refreshProxiedConfigurations, size=" + proxiedConfigurations.size(), new Object[0]);
        for (ConfigurationPlusProxy wrapper : proxiedConfigurations.values()) {
            try {
                wrapper.refreshProxiedConfiguration();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ConfigurationPlusProxy(MybatisXMLConfigBuilder configBuilder) {
        this.configBuilder = configBuilder;
    }

    public void refreshProxiedConfiguration() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.configuration = new MybatisConfiguration();
        ReflectionHelper.invoke(this.configBuilder, "$$ha$refresh");
    }

    public Configuration proxy(Configuration origConfiguration) {
        if (origConfiguration == null) {
            return null;
        }
        this.configuration = (MybatisConfiguration)origConfiguration;
        if (this.proxyInstance == null) {
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(MybatisConfiguration.class);
            MethodHandler handler = new MethodHandler(){

                @Override
                public Object invoke(Object self, Method overridden, Method forwarder, Object[] args) throws Throwable {
                    return overridden.invoke((Object)ConfigurationPlusProxy.this.configuration, args);
                }
            };
            try {
                this.proxyInstance = (MybatisConfiguration)factory.create(new Class[0], null, handler);
            }
            catch (Exception e) {
                throw new Error("Unable instantiate Configuration proxy", e);
            }
        }
        return this.proxyInstance;
    }

    public static boolean isMybatisEntity(Class<?> clazz) {
        LOGGER.debug("isMybatisEntity, clazz={}, configuration size={}", clazz, proxiedConfigurations.size());
        for (ConfigurationPlusProxy configurationProxy : proxiedConfigurations.values()) {
            if (!MybatisPlusConfigurationCaller.isMybatisObj((Configuration)configurationProxy.configuration, clazz)) continue;
            return true;
        }
        return false;
    }
}

