/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.myfaces;

import java.lang.reflect.Method;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassFileEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.myfaces.command.ReloadManagedBeanCommand;
import org.hotswap.agent.plugin.myfaces.transformer.LifecycleImplTransformer;
import org.hotswap.agent.plugin.myfaces.transformer.ManagedBeanResolverTransformer;
import org.hotswap.agent.plugin.myfaces.transformer.MyFacesTransformer;
import org.hotswap.agent.util.AnnotationHelper;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="MyFaces", description="JSF/MyFaces. Clear resource bundle cache when *.properties files are changed.", testedVersions={"2.2.10"}, expectedVersions={"2.2"}, supportClass={MyFacesTransformer.class, ManagedBeanResolverTransformer.class, LifecycleImplTransformer.class})
public class MyFacesPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(MyFacesPlugin.class);
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    private Command refreshResourceBundles = new Command(){

        @Override
        public void executeCommand() {
            LOGGER.debug("Refreshing JSF resource bundles.", new Object[0]);
            try {
                Class clazz = MyFacesPlugin.this.resolveClass("java.util.ResourceBundle");
                Method clearCacheMethod = clazz.getDeclaredMethod("clearCache", ClassLoader.class);
                clearCacheMethod.invoke(null, MyFacesPlugin.this.appClassLoader);
            }
            catch (Exception e) {
                LOGGER.error("Error clear JSF resource bundles cache", e, new Object[0]);
            }
        }
    };

    @Init
    public void init(PluginConfiguration pluginConfiguration) {
        LOGGER.info("MyFaces plugin initialized.", new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp="org.apache.myfaces.config.RuntimeConfig")
    public static void facesApplicationAssociateInitialized(CtClass ctClass) throws NotFoundException, CannotCompileException {
        String buildInitializePlugin = PluginManagerInvoker.buildInitializePlugin(MyFacesPlugin.class);
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(buildInitializePlugin);
        }
        LOGGER.debug("org.apache.myfaces.config.RuntimeConfig with plugin initialization.", new Object[0]);
    }

    @OnResourceFileEvent(path="/", filter=".*.properties")
    public void refreshJsfResourceBundles() {
        this.scheduler.scheduleCommand(this.refreshResourceBundles);
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void reloadManagedBean(Class<?> beanClass) {
        if (!AnnotationHelper.hasAnnotation(beanClass, "javax.faces.bean.ManagedBean")) {
            return;
        }
        ReloadManagedBeanCommand command = new ReloadManagedBeanCommand(beanClass, this.appClassLoader);
        this.scheduler.scheduleCommand(command);
    }

    @OnClassFileEvent(classNameRegexp=".*", events={FileEvent.CREATE})
    public void registerManagedBean(CtClass beanCtClass) throws Exception {
        if (!AnnotationHelper.hasAnnotation(beanCtClass, "javax.faces.bean.ManagedBean")) {
            return;
        }
        ReloadManagedBeanCommand command = new ReloadManagedBeanCommand(beanCtClass, this.appClassLoader);
        this.scheduler.scheduleCommand(command);
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }
}

