/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb_jakarta.beans;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.owb_jakarta.beans.OwbHotswapContext;

public class ContextualReloadHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ContextualReloadHelper.class);

    public static void reload(OwbHotswapContext ctx) {
        Set<Contextual<Object>> beans = ctx.$$ha$getBeansToReloadOwb();
        if (beans != null && !beans.isEmpty()) {
            LOGGER.debug("Starting re-loading {} beans in context '{}'", beans.size(), ctx);
            for (Contextual<Object> managedBean : beans) {
                ContextualReloadHelper.destroy(ctx, managedBean);
            }
            beans.clear();
            LOGGER.debug("Finished re-loading beans in context '{}'", ctx);
        }
    }

    public static boolean addToReloadSet(Context ctx, Contextual<?> managedBean) {
        try {
            LOGGER.debug("Adding bean '{}' to context '{}'", managedBean, ctx.getClass());
            Field toRedefine = ctx.getClass().getField("$$ha$toReloadOwb");
            HashSet toReload = (HashSet)Set.class.cast(toRedefine.get(ctx));
            if (toReload == null) {
                toReload = new HashSet();
                toRedefine.set(ctx, toReload);
            }
            toReload.add(managedBean);
            return true;
        }
        catch (Exception e) {
            LOGGER.warning("Context '{}' is not patched. Can not add bean '{}' to reload set", e, ctx, managedBean);
            return false;
        }
    }

    static void destroy(OwbHotswapContext ctx, Contextual<?> managedBean) {
        try {
            LOGGER.debug("Removing bean '{}' from context '{}'", managedBean, ctx);
            Object get = ctx.get(managedBean);
            if (get != null) {
                ctx.destroy(managedBean);
            }
            if ((get = ctx.get(managedBean)) != null) {
                LOGGER.error("Error removing ManagedBean '{}', it still exists as instance '{}'", managedBean, get);
                ctx.destroy(managedBean);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error destoying bean '{}' in context '{}'", e, managedBean, ctx);
        }
    }

    static void reinitialize(Context ctx, Contextual<Object> contextual) {
        try {
            ManagedBean managedBean = (ManagedBean)ManagedBean.class.cast(contextual);
            LOGGER.debug("Re-Initializing bean '{}' in context '{}'", managedBean, ctx);
            Object get = ctx.get((Contextual)managedBean);
            if (get != null) {
                LOGGER.debug("Bean injection points are reinitialized '{}'", managedBean);
                CreationalContextImpl creationalContext = managedBean.getWebBeansContext().getCreationalContextFactory().getCreationalContext((Contextual)managedBean);
                managedBean.getProducer().inject(get, (CreationalContext)creationalContext);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reinitializing bean '{}' in context '{}'", e, contextual, ctx);
        }
    }
}

