/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.api;

import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.plugin.proxy.ProxyClassSignatureHelper;
import org.hotswap.agent.plugin.proxy.api.ProxyBytecodeGenerator;
import org.hotswap.agent.plugin.proxy.api.ProxyBytecodeTransformer;
import org.hotswap.agent.plugin.proxy.api.ProxyTransformer;

public abstract class AbstractProxyTransformer
implements ProxyTransformer {
    protected ProxyBytecodeGenerator generator;
    protected ProxyBytecodeTransformer transformer;
    protected Class<?> classBeingRedefined;
    protected ClassPool classPool;

    public AbstractProxyTransformer(Class<?> classBeingRedefined, ClassPool classPool) {
        this.classBeingRedefined = classBeingRedefined;
        this.classPool = classPool;
    }

    protected ProxyBytecodeGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = this.createGenerator();
        }
        return this.generator;
    }

    protected ProxyBytecodeTransformer getTransformer() {
        if (this.transformer == null) {
            this.transformer = this.createTransformer();
        }
        return this.transformer;
    }

    protected abstract ProxyBytecodeGenerator createGenerator();

    protected abstract ProxyBytecodeTransformer createTransformer();

    protected boolean isTransformingNeeded() {
        return ProxyClassSignatureHelper.isNonSyntheticPoolClassOrParentDifferent(this.classBeingRedefined, this.classPool);
    }
}

