/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.api;

import java.util.Map;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.RedefinitionScheduler;
import org.hotswap.agent.plugin.proxy.api.AbstractProxyTransformer;
import org.hotswap.agent.plugin.proxy.api.ProxyBytecodeGenerator;
import org.hotswap.agent.plugin.proxy.api.ProxyBytecodeTransformer;
import org.hotswap.agent.plugin.proxy.api.TransformationState;

public abstract class MultistepProxyTransformer
extends AbstractProxyTransformer {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(MultistepProxyTransformer.class);
    public static boolean addThirdStep = false;
    protected byte[] classfileBuffer;
    protected Map<Class<?>, TransformationState> transformationStates;
    protected ProxyBytecodeGenerator generator;
    protected ProxyBytecodeTransformer transformer;

    public MultistepProxyTransformer(Class<?> classBeingRedefined, ClassPool classPool, byte[] classfileBuffer, Map<Class<?>, TransformationState> transformationStates) {
        super(classBeingRedefined, classPool);
        this.classPool = classPool;
        this.transformationStates = transformationStates;
        this.classfileBuffer = classfileBuffer;
    }

    @Override
    public byte[] transformRedefine() throws Exception {
        switch (this.getTransformationstate()) {
            case NEW: {
                if (!this.isTransformingNeeded()) {
                    return this.classfileBuffer;
                }
                this.setClassAsWaiting();
                this.scheduleRedefinition();
                return this.classfileBuffer;
            }
            case WAITING: {
                this.classfileBuffer = this.getTransformer().transform(this.getGenerator().generate());
                LOGGER.reload("Class '{}' has been reloaded.", this.classBeingRedefined.getName());
                if (addThirdStep) {
                    this.setClassAsFinished();
                    this.scheduleRedefinition();
                } else {
                    this.removeClassState();
                }
                return this.classfileBuffer;
            }
            case FINISHED: {
                this.removeClassState();
                return this.classfileBuffer;
            }
        }
        throw new RuntimeException("Unhandeled TransformationState!");
    }

    protected TransformationState getTransformationstate() {
        TransformationState transformationState = this.transformationStates.get(this.classBeingRedefined);
        if (transformationState == null) {
            transformationState = TransformationState.NEW;
        }
        return transformationState;
    }

    protected void scheduleRedefinition() {
        RedefinitionScheduler.schedule(this);
    }

    protected TransformationState setClassAsWaiting() {
        return this.transformationStates.put(this.classBeingRedefined, TransformationState.WAITING);
    }

    protected TransformationState setClassAsFinished() {
        return this.transformationStates.put(this.classBeingRedefined, TransformationState.FINISHED);
    }

    public TransformationState removeClassState() {
        return this.transformationStates.remove(this.classBeingRedefined);
    }

    public Class<?> getClassBeingRedefined() {
        return this.classBeingRedefined;
    }

    public byte[] getClassfileBuffer() {
        return this.classfileBuffer;
    }
}

