/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.sponge;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.logging.AgentLogger;

final class ReloadListenersCommand
implements Command {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(ReloadListenersCommand.class);
    private final ClassLoader appClassLoader;
    private final Set<Object> eventManagers;
    private final Map<Object, MethodHandles.Lookup> lookups;
    private final Set<Consumer<Class<?>>> callbacks;
    private final Class<?> listenerClass;

    ReloadListenersCommand(ClassLoader appClassLoader, Set<Object> eventManagers, Map<Object, MethodHandles.Lookup> lookups, Set<Consumer<Class<?>>> callbacks, Class<?> listenerClass) {
        this.appClassLoader = appClassLoader;
        this.eventManagers = eventManagers;
        this.lookups = lookups;
        this.callbacks = callbacks;
        this.listenerClass = listenerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand() {
        try {
            Class<?> spongeEventManagerClass = Class.forName("org.spongepowered.common.event.manager.SpongeEventManager", true, this.appClassLoader);
            Class<?> registeredListenerClass = Class.forName("org.spongepowered.common.event.manager.RegisteredListener", true, this.appClassLoader);
            Class<?> multiMapClass = Class.forName("com.google.common.collect.Multimap", true, this.appClassLoader);
            Class<?> pluginContainerClass = Class.forName("org.spongepowered.plugin.PluginContainer", true, this.appClassLoader);
            Field handlersByEventField = spongeEventManagerClass.getDeclaredField("handlersByEvent");
            handlersByEventField.setAccessible(true);
            Field lockField = spongeEventManagerClass.getDeclaredField("lock");
            lockField.setAccessible(true);
            Method unregisterListenersMethod = spongeEventManagerClass.getDeclaredMethod("unregisterListeners", Object.class);
            Method registerListenersMethod = spongeEventManagerClass.getDeclaredMethod("registerListeners", pluginContainerClass, Object.class);
            Method registerListenersLookupMethod = spongeEventManagerClass.getDeclaredMethod("registerListeners", pluginContainerClass, Object.class, MethodHandles.Lookup.class);
            Method valuesMethod = multiMapClass.getMethod("values", new Class[0]);
            Method getHandleMethod = registeredListenerClass.getMethod("getHandle", new Class[0]);
            Method getPluginMethod = registeredListenerClass.getMethod("getPlugin", new Class[0]);
            HashMap<Object, HandleData> handles = new HashMap<Object, HandleData>();
            Iterator<Consumer<Class<?>>> iterator = this.eventManagers;
            synchronized (iterator) {
                for (Object eventManager : this.eventManagers) {
                    Object multiMap = handlersByEventField.get(eventManager);
                    Object object = lockField.get(eventManager);
                    synchronized (object) {
                        Collection values = (Collection)valuesMethod.invoke(multiMap, new Object[0]);
                        for (Object listener : values) {
                            Object handle = getHandleMethod.invoke(listener, new Object[0]);
                            if (!handle.getClass().equals(this.listenerClass)) continue;
                            Object plugin = getPluginMethod.invoke(listener, new Object[0]);
                            handles.computeIfAbsent(handle, $ -> new HandleData(plugin)).eventManagers.add(eventManager);
                        }
                    }
                }
            }
            if (handles.isEmpty()) {
                return;
            }
            for (Map.Entry entry : handles.entrySet()) {
                Object handle = entry.getKey();
                HandleData data = (HandleData)entry.getValue();
                MethodHandles.Lookup lookup = this.lookups.get(handle);
                for (Object eventManager : data.eventManagers) {
                    unregisterListenersMethod.invoke(eventManager, handle);
                    if (lookup == null) {
                        registerListenersMethod.invoke(eventManager, data.plugin, handle);
                        continue;
                    }
                    registerListenersLookupMethod.invoke(eventManager, data.plugin, handle, lookup);
                }
            }
            LOGGER.info("Successfully refreshed listeners for {}", this.listenerClass);
            for (Consumer<Class<?>> consumer : this.callbacks) {
                try {
                    consumer.accept(this.listenerClass);
                }
                catch (Throwable e) {
                    LOGGER.error("Listener update callback threw exception {}", e, this.listenerClass);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error refreshing listeners for {}", e, this.listenerClass);
        }
    }

    private static final class HandleData {
        private final Object plugin;
        private final Set<Object> eventManagers;

        private HandleData(Object plugin) {
            this.plugin = plugin;
            this.eventManagers = new HashSet<Object>();
        }
    }
}

