/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring;

import java.security.ProtectionDomain;
import java.util.Objects;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.plugin.spring.SpringChangesAnalyzer;
import org.hotswap.agent.plugin.spring.scanner.ClassPathBeanRefreshCommand;
import org.hotswap.agent.util.HaClassFileTransformer;

public class SpringBeanClassFileTransformer
implements HaClassFileTransformer {
    private ClassLoader appClassLoader;
    private Scheduler scheduler;
    private String basePackage;

    public SpringBeanClassFileTransformer(ClassLoader appClassLoader, Scheduler scheduler, String basePackage) {
        this.appClassLoader = appClassLoader;
        this.scheduler = scheduler;
        this.basePackage = basePackage;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        SpringChangesAnalyzer analyzer;
        if (classBeingRedefined != null && (analyzer = new SpringChangesAnalyzer(this.appClassLoader)).isReloadNeeded(classBeingRedefined, classfileBuffer)) {
            this.scheduler.scheduleCommand(new ClassPathBeanRefreshCommand(classBeingRedefined.getClassLoader(), this.basePackage, className, classfileBuffer, this.scheduler));
        }
        return classfileBuffer;
    }

    @Override
    public boolean isForRedefinitionOnly() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringBeanClassFileTransformer that = (SpringBeanClassFileTransformer)o;
        return Objects.equals(this.appClassLoader, that.appClassLoader) && Objects.equals(this.basePackage, that.basePackage);
    }

    public int hashCode() {
        return Objects.hash(this.appClassLoader, this.basePackage);
    }
}

