/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.boot.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.boot.env.HotswapSpringPropertiesReloader;
import org.hotswap.agent.plugin.spring.boot.env.HotswapSpringReloadMap;
import org.springframework.core.io.Resource;

public class ListPropertySourceReloader<T>
implements HotswapSpringPropertiesReloader<List<Map<String, T>>> {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ListPropertySourceReloader.class);
    protected final String name;
    protected final Resource resource;
    protected List<Map<String, T>> hotswapMapList;

    public ListPropertySourceReloader(String name, Resource resource) {
        this.name = name;
        this.resource = resource;
    }

    Map<String, T> createMap(Map map) {
        return new HotswapSpringReloadMap(map);
    }

    void updateItemValue(Map hotswapMap, Map newHotswapMap) {
        if (hotswapMap instanceof HotswapSpringReloadMap) {
            ((HotswapSpringReloadMap)hotswapMap).update(newHotswapMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(List<Map<String, T>> newValue) {
        if (newValue == null || newValue.isEmpty()) {
            this.hotswapMapList = newValue == null ? Collections.emptyList() : newValue;
            return;
        }
        if (this.hotswapMapList == null) {
            ListPropertySourceReloader listPropertySourceReloader = this;
            synchronized (listPropertySourceReloader) {
                if (this.hotswapMapList == null) {
                    this.hotswapMapList = new ArrayList<Map<String, T>>(newValue.size());
                    for (Map<String, T> map : newValue) {
                        this.hotswapMapList.add(this.createMap(map));
                    }
                    return;
                }
            }
        }
        for (int i = 0; i < this.hotswapMapList.size(); ++i) {
            Map<String, T> hotswapMap = this.hotswapMapList.get(i);
            Map<String, T> newHotswapMap = newValue.get(i);
            this.updateItemValue(hotswapMap, newHotswapMap);
        }
    }

    @Override
    public List<Map<String, T>> get() {
        return this.hotswapMapList;
    }
}

