/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.utils.RegistryUtils;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.spring.util.ObjectUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.Conventions;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class ConfigurationClassPostProcessorEnhance {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(ConfigurationClassPostProcessorEnhance.class);
    private static final Map<BeanDefinitionRegistry, ConfigurationClassPostProcessorEnhance> INSTANCES = new ConcurrentHashMap<BeanDefinitionRegistry, ConfigurationClassPostProcessorEnhance>(4);
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, (String)"configurationClass");
    private volatile ConfigurationClassPostProcessor processor;

    public static ConfigurationClassPostProcessorEnhance getInstance(BeanDefinitionRegistry registry) {
        ConfigurationClassPostProcessorEnhance result = INSTANCES.putIfAbsent(registry, new ConfigurationClassPostProcessorEnhance());
        if (result == null) {
            result = INSTANCES.get(registry);
        }
        return result;
    }

    private ConfigurationClassPostProcessorEnhance() {
    }

    public void setProcessor(ConfigurationClassPostProcessor processor) {
        LOGGER.trace("ConfigurationClassPostProcessorAgent.setProcessor({})", processor);
        this.processor = processor;
    }

    public ConfigurationClassPostProcessor getProcessor() {
        return this.processor;
    }

    public void resetConfigurationClassPostProcessor(BeanDefinitionRegistry registry) {
        LOGGER.trace("ConfigurationClassPostProcessorAgent.resetConfigurationClassPostProcessor({})", new Object[0]);
        if (this.processor == null) {
            return;
        }
        this.resetCachingMetadataReaderFactoryCache();
        this.resetBeanNameCache();
        this.resetBeanFactoryCache(registry);
    }

    public void postProcess(BeanDefinitionRegistry registry, String beanName) {
        if (this.processor == null) {
            return;
        }
        this.resetCachingMetadataReaderFactoryCache();
        this.resetBeanNameCache();
        this.resetBeanFactoryCache(registry);
        this.removeBeanAttribute(registry, beanName);
        this.processor.processConfigBeanDefinitions(registry);
    }

    public void postProcess(BeanDefinitionRegistry registry) {
        LOGGER.trace("ConfigurationClassPostProcessorAgent.postProcess({})", ObjectUtils.identityToString(registry));
        if (this.processor == null) {
            return;
        }
        this.resetCachingMetadataReaderFactoryCache();
        this.resetBeanNameCache();
        this.resetBeanFactoryCache(registry);
        this.processor.processConfigBeanDefinitions(registry);
    }

    private MetadataReaderFactory getMetadataReaderFactory() {
        return (MetadataReaderFactory)ReflectionHelper.getNoException(this.processor, ConfigurationClassPostProcessor.class, "metadataReaderFactory");
    }

    private void resetCachingMetadataReaderFactoryCache() {
        LOGGER.trace("Clearing MetadataReaderFactory cache", new Object[0]);
        MetadataReaderFactory metadataReaderFactory = this.getMetadataReaderFactory();
        if (metadataReaderFactory != null) {
            try {
                ReflectionHelper.invoke(metadataReaderFactory, "clearCache");
            }
            catch (Exception e) {
                LOGGER.debug("Unable to clear MetadataReaderFactory cache", new Object[0]);
            }
        }
    }

    private void resetBeanFactoryCache(BeanDefinitionRegistry registry) {
        LOGGER.trace("Clearing BeanFactory cache", new Object[0]);
        DefaultListableBeanFactory beanFactory = RegistryUtils.maybeRegistryToBeanFactory(registry);
        if (beanFactory == null) {
            return;
        }
        beanFactory.setAllowBeanDefinitionOverriding(true);
        this.resetFactoryMethodCandidateCache(beanFactory);
    }

    private void removeBeanAttribute(BeanDefinitionRegistry registry, String beanName) {
        BeanDefinition bd = registry.getBeanDefinition(beanName);
        if (bd.hasAttribute(CONFIGURATION_CLASS_ATTRIBUTE)) {
            LOGGER.trace("Removing attribute '{}' from bean definition '{}'", CONFIGURATION_CLASS_ATTRIBUTE, beanName);
            bd.removeAttribute(CONFIGURATION_CLASS_ATTRIBUTE);
        }
    }

    private void resetFactoryMethodCandidateCache(DefaultListableBeanFactory factory) {
        Map cache = (Map)ReflectionHelper.getNoException(factory, AbstractAutowireCapableBeanFactory.class, "factoryMethodCandidateCache");
        if (cache != null) {
            LOGGER.trace("Cache cleared: AbstractAutowireCapableBeanFactory.factoryMethodCandidateCache", new Object[0]);
            cache.clear();
        }
    }

    private void resetBeanNameCache() {
        Map cache = (Map)ReflectionHelper.getNoException(null, "org.springframework.context.annotation.BeanAnnotationHelper", this.processor.getClass().getClassLoader(), "beanNameCache");
        if (cache != null) {
            LOGGER.trace("Cache cleared: BeanAnnotationHelper.beanNameCache", new Object[0]);
            cache.clear();
        }
    }
}

