/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.core;

import java.lang.reflect.Field;
import java.util.Set;
import org.hotswap.agent.logging.AgentLogger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;

public class ResetBeanFactoryPostProcessorCaches {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(ResetBeanFactoryPostProcessorCaches.class);

    public static void reset(DefaultListableBeanFactory beanFactory) {
        ResetBeanFactoryPostProcessorCaches.resetConfigurationClassPostProcessorCache(beanFactory);
    }

    private static void resetConfigurationClassPostProcessorCache(DefaultListableBeanFactory beanFactory) {
        LOGGER.trace("Resetting ConfigurationClassPostProcessor caches", new Object[0]);
        int factoryId = System.identityHashCode(beanFactory);
        try {
            ConfigurationClassPostProcessor ccpp = (ConfigurationClassPostProcessor)beanFactory.getBean(ConfigurationClassPostProcessor.class);
            ResetBeanFactoryPostProcessorCaches.clearSetFieldOfConfigurationClassPostProcessor(ccpp, "factoriesPostProcessed", factoryId);
            ResetBeanFactoryPostProcessorCaches.clearSetFieldOfConfigurationClassPostProcessor(ccpp, "registriesPostProcessed", factoryId);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.trace("ConfigurationClassPostProcessor bean doesn't present", new Object[0]);
        }
    }

    private static void clearSetFieldOfConfigurationClassPostProcessor(ConfigurationClassPostProcessor ccpp, String fieldName, int factoryId) {
        try {
            Field field = ConfigurationClassPostProcessor.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            Set set = (Set)field.get(ccpp);
            set.remove(factoryId);
        }
        catch (Exception e) {
            LOGGER.debug("Error while resetting ConfigurationClassPostProcessor caches", e, new Object[0]);
        }
    }
}

