/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.files;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.core.BeanFactoryProcessor;
import org.hotswap.agent.plugin.spring.files.PropertiesChangeEvent;
import org.hotswap.agent.plugin.spring.listener.SpringEventSource;
import org.hotswap.agent.plugin.spring.transformers.api.ReloadablePropertySource;
import org.hotswap.agent.plugin.spring.transformers.api.ReloadableResourcePropertySource;
import org.hotswap.agent.plugin.spring.utils.AnnotatedBeanDefinitionUtils;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.spring.util.ObjectUtils;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class PropertyReload {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PropertyReload.class);

    public static void reloadPropertySource(DefaultListableBeanFactory beanFactory) {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        if (environment != null) {
            Map<String, String> oldValueMap = PropertyReload.getPropertyOfPropertySource(environment);
            PropertyReload.doReloadPropertySource(environment.getPropertySources());
            PropertyReload.processChangedValue(beanFactory, environment, oldValueMap);
        }
        PropertyReload.refreshPlaceholderConfigurerSupport(beanFactory);
    }

    private static Map<String, String> getPropertyOfPropertySource(ConfigurableEnvironment environment) {
        HashSet canModifiedKey = new HashSet();
        HashMap<String, String> result = new HashMap<String, String>();
        PropertyReload.processKeysOfPropertySource(environment.getPropertySources(), canModifiedKey::addAll);
        for (String key : canModifiedKey) {
            result.put(key, environment.getProperty(key));
        }
        return result;
    }

    private static void processChangedValue(DefaultListableBeanFactory beanFactory, ConfigurableEnvironment environment, Map<String, String> oldValueMap) {
        HashSet canModifiedKey = new HashSet();
        PropertyReload.processKeysOfPropertySource(environment.getPropertySources(), canModifiedKey::addAll);
        ArrayList<PropertiesChangeEvent.PropertyChangeItem> propertyChangeItems = new ArrayList<PropertiesChangeEvent.PropertyChangeItem>();
        for (String key : canModifiedKey) {
            String oldValue = oldValueMap.get(key);
            String newValue = environment.getProperty(key);
            if ((oldValue == null || oldValue.equals(newValue)) && (oldValue != null || newValue == null)) continue;
            propertyChangeItems.add(new PropertiesChangeEvent.PropertyChangeItem(key, oldValue, newValue));
            LOGGER.debug("property of '{}' reload, key:{}, oldValue:{}, newValue:{}", ObjectUtils.identityToString(beanFactory), key, oldValue, newValue);
        }
        if (!propertyChangeItems.isEmpty()) {
            SpringEventSource.INSTANCE.fireEvent(new PropertiesChangeEvent((List<PropertiesChangeEvent.PropertyChangeItem>)propertyChangeItems, (ConfigurableListableBeanFactory)beanFactory));
        }
    }

    private static void processKeysOfPropertySource(MutablePropertySources propertySources, Consumer<Set<String>> consumer) {
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource instanceof MapPropertySource)) continue;
            consumer.accept(((Map)((MapPropertySource)propertySource).getSource()).keySet());
        }
    }

    private static void doReloadPropertySource(MutablePropertySources propertySources) {
        for (PropertySource propertySource : propertySources) {
            if (propertySource instanceof ReloadableResourcePropertySource) {
                try {
                    ((ReloadableResourcePropertySource)propertySource).reload();
                }
                catch (IOException e) {
                    LOGGER.error("reload property source error", e, propertySource.getName());
                }
            }
            if (!(propertySource instanceof ReloadablePropertySource)) continue;
            ((ReloadablePropertySource)propertySource).reload();
        }
    }

    private static void refreshPlaceholderConfigurerSupport(DefaultListableBeanFactory beanFactory) {
        String[] beanFactoryBeanNamesForTypes = beanFactory.getBeanNamesForType(PlaceholderConfigurerSupport.class);
        if (beanFactoryBeanNamesForTypes != null) {
            for (String beanFactoryBeanName : beanFactoryBeanNamesForTypes) {
                PlaceholderConfigurerSupport placeholderConfigurerSupport = (PlaceholderConfigurerSupport)beanFactory.getBean(beanFactoryBeanName, PlaceholderConfigurerSupport.class);
                PropertyReload.refreshSinglePlaceholderConfigurerSupport(beanFactory, placeholderConfigurerSupport);
            }
        }
    }

    private static void refreshSinglePlaceholderConfigurerSupport(DefaultListableBeanFactory beanFactory, PlaceholderConfigurerSupport placeholderConfigurerSupport) {
        if (placeholderConfigurerSupport instanceof PropertySourcesPlaceholderConfigurer) {
            PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer = (PropertySourcesPlaceholderConfigurer)placeholderConfigurerSupport;
            MutablePropertySources origPropertySources = PropertyReload.getPropertySources(propertySourcesPlaceholderConfigurer);
            origPropertySources.forEach(propertySource -> origPropertySources.remove(propertySource.getName()));
            ReflectionHelper.set(propertySourcesPlaceholderConfigurer, "propertySources", null);
            propertySourcesPlaceholderConfigurer.postProcessBeanFactory((ConfigurableListableBeanFactory)beanFactory);
            MutablePropertySources curPropertySources = PropertyReload.getPropertySources(propertySourcesPlaceholderConfigurer);
            curPropertySources.forEach(propertySource -> origPropertySources.addLast(propertySource));
            ReflectionHelper.set(propertySourcesPlaceholderConfigurer, "propertySources", origPropertySources);
        } else if (placeholderConfigurerSupport instanceof PropertyPlaceholderConfigurer) {
            PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = (PropertyPlaceholderConfigurer)placeholderConfigurerSupport;
            propertyPlaceholderConfigurer.postProcessBeanFactory((ConfigurableListableBeanFactory)beanFactory);
        }
    }

    private static MutablePropertySources getPropertySources(PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer) {
        return (MutablePropertySources)ReflectionHelper.getNoException(propertySourcesPlaceholderConfigurer, propertySourcesPlaceholderConfigurer.getClass(), "propertySources");
    }

    public static Set<String> getContainValueAnnotationBeans(DefaultListableBeanFactory beanFactory) {
        HashSet<String> needRecreateBeans = new HashSet<String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            AnnotatedBeanDefinition annotatedBeanDefinition;
            RootBeanDefinition currentBeanDefinition;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            if (beanDefinition instanceof RootBeanDefinition) {
                currentBeanDefinition = (RootBeanDefinition)beanDefinition;
                if (!PropertyReload.containValueAnnotationInMethod(beanFactory, currentBeanDefinition)) continue;
                needRecreateBeans.add(beanName);
                continue;
            }
            if (!(beanDefinition instanceof GenericBeanDefinition) || AnnotatedBeanDefinitionUtils.getFactoryMethodMetadata(annotatedBeanDefinition = (AnnotatedBeanDefinition)(currentBeanDefinition = (GenericBeanDefinition)beanDefinition)) != null || !BeanFactoryProcessor.needReloadOnConstructor(beanFactory, (AbstractBeanDefinition)currentBeanDefinition, beanName, constructors -> PropertyReload.checkConstructorContainsValueAnnotation(constructors))) continue;
            needRecreateBeans.add(beanName);
        }
        return needRecreateBeans;
    }

    private static boolean containValueAnnotationInMethod(DefaultListableBeanFactory beanFactory, RootBeanDefinition currentBeanDefinition) {
        if (currentBeanDefinition.getFactoryMethodName() != null && currentBeanDefinition.getFactoryBeanName() != null) {
            Method method = currentBeanDefinition.getResolvedFactoryMethod();
            if (method == null) {
                Method[] methods;
                Object factoryBean = beanFactory.getBean(currentBeanDefinition.getFactoryBeanName());
                Class factoryClass = ClassUtils.getUserClass(factoryBean.getClass());
                for (Method m : methods = PropertyReload.getCandidateMethods(factoryClass, currentBeanDefinition)) {
                    if (Modifier.isStatic(m.getModifiers()) || !currentBeanDefinition.isFactoryMethod(m) || m.getParameterCount() == 0 || !AnnotatedBeanDefinitionUtils.containValueAnnotation(m.getParameterAnnotations())) continue;
                    return true;
                }
            } else if (method.getParameterCount() != 0 && AnnotatedBeanDefinitionUtils.containValueAnnotation(method.getParameterAnnotations())) {
                return true;
            }
        }
        return false;
    }

    private static Method[] getCandidateMethods(Class<?> factoryClass, RootBeanDefinition mbd) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods((Class)factoryClass) : factoryClass.getMethods());
        }
        return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }

    private static boolean checkConstructorContainsValueAnnotation(Constructor<?>[] constructors) {
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() == 0 || !AnnotatedBeanDefinitionUtils.containValueAnnotation(constructor.getParameterAnnotations())) continue;
            return true;
        }
        return false;
    }
}

