/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.getbean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.WeakHashMap;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.javassist.LoaderClassPath;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.getbean.DetachableBeanHolder;
import org.hotswap.agent.plugin.spring.getbean.SpringHotswapAgentProxy;
import org.springframework.core.SpringVersion;

public class EnhancerProxyCreater {
    private static AgentLogger LOGGER = AgentLogger.getLogger(EnhancerProxyCreater.class);
    private static EnhancerProxyCreater INSTANCE;
    public static final String SPRING_PACKAGE = "org.springframework.cglib.";
    public static final String CGLIB_PACKAGE = "net.sf.cglib.";
    private Class<?> springProxy;
    private Class<?> springCallback;
    private Class<?> springNamingPolicy;
    private Method createSpringProxy;
    private Class<?> cglibProxy;
    private Class<?> cglibCallback;
    private Class<?> cglibNamingPolicy;
    private Method createCglibProxy;
    private Object springLock = new Object();
    private Object cglibLock = new Object();
    private final ClassLoader loader;
    private final ProtectionDomain pd;
    private final Map<Object, Object> beanProxies = new WeakHashMap<Object, Object>();

    public EnhancerProxyCreater(ClassLoader loader, ProtectionDomain pd) {
        this.loader = loader;
        this.pd = pd;
    }

    public static boolean isSupportedCglibProxy(Object bean) {
        if (bean == null) {
            return false;
        }
        String beanClassName = bean.getClass().getName();
        return beanClassName.contains("$$EnhancerBySpringCGLIB") || beanClassName.contains("$$EnhancerByCGLIB");
    }

    public static Object createProxy(Object beanFactry, Object bean, Class<?>[] paramClasses, Object[] paramValues) {
        if (INSTANCE == null) {
            INSTANCE = new EnhancerProxyCreater(bean.getClass().getClassLoader(), bean.getClass().getProtectionDomain());
        }
        return INSTANCE.create(beanFactry, bean, paramClasses, paramValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object create(Object beanFactry, Object bean, Class<?>[] paramClasses, Object[] paramValues) {
        Object proxyBean = null;
        if (this.beanProxies.containsKey(bean)) {
            proxyBean = this.beanProxies.get(bean);
        } else {
            Map<Object, Object> map = this.beanProxies;
            synchronized (map) {
                proxyBean = this.beanProxies.containsKey(bean) ? bean : this.doCreate(beanFactry, bean, paramClasses, paramValues);
                this.beanProxies.put(bean, proxyBean);
            }
        }
        if (proxyBean instanceof SpringHotswapAgentProxy) {
            ((SpringHotswapAgentProxy)proxyBean).$$ha$setTarget(bean);
        }
        return proxyBean;
    }

    private Object doCreate(Object beanFactry, Object bean, Class<?>[] paramClasses, Object[] paramValues) {
        try {
            Method proxyCreater = this.getProxyCreationMethod(bean);
            if (proxyCreater == null) {
                return bean;
            }
            return proxyCreater.invoke(null, beanFactry, bean, paramClasses, paramValues);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            LOGGER.warning("Can't create proxy for " + bean.getClass().getSuperclass() + " because there is no default constructor, which means your non-singleton bean created before won't get rewired with new props when update class.", new Object[0]);
            return bean;
        }
        catch (IllegalAccessException | CannotCompileException | NotFoundException e) {
            LOGGER.error("Creating a proxy failed", e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getProxyCreationMethod(Object bean) throws CannotCompileException, NotFoundException {
        if (this.getCp(this.loader).find("org.springframework.cglib.proxy.MethodInterceptor") != null) {
            if (this.createSpringProxy == null) {
                Object object = this.springLock;
                synchronized (object) {
                    if (this.createSpringProxy == null) {
                        ClassPool cp = this.getCp(this.loader);
                        this.springCallback = this.buildProxyCallbackClass(SPRING_PACKAGE, cp);
                        this.springNamingPolicy = this.buildNamingPolicyClass(SPRING_PACKAGE, cp);
                        this.springProxy = this.buildProxyCreaterClass(SPRING_PACKAGE, this.springCallback, this.springNamingPolicy, cp);
                        this.createSpringProxy = this.springProxy.getDeclaredMethods()[0];
                    }
                }
            }
            return this.createSpringProxy;
        }
        if (this.getCp(this.loader).find("net.sf.cglib.proxy.MethodInterceptor") != null) {
            if (this.createCglibProxy == null) {
                Object object = this.cglibLock;
                synchronized (object) {
                    if (this.createCglibProxy == null) {
                        ClassPool cp = this.getCp(this.loader);
                        this.cglibCallback = this.buildProxyCallbackClass(CGLIB_PACKAGE, cp);
                        this.cglibNamingPolicy = this.buildNamingPolicyClass(CGLIB_PACKAGE, cp);
                        this.cglibProxy = this.buildProxyCreaterClass(CGLIB_PACKAGE, this.cglibCallback, this.cglibNamingPolicy, cp);
                        this.createCglibProxy = this.cglibProxy.getDeclaredMethods()[0];
                    }
                }
            }
            return this.createCglibProxy;
        }
        LOGGER.error("Unable to determine the location of the Cglib package", new Object[0]);
        return null;
    }

    private Class<?> buildProxyCreaterClass(String cglibPackage, Class<?> callback, Class<?> namingPolicy, ClassPool cp) throws CannotCompileException {
        CtClass ct = cp.makeClass("HotswapAgentSpringBeanProxy" + EnhancerProxyCreater.getClassSuffix(cglibPackage));
        String proxy = cglibPackage + "proxy.";
        String core = cglibPackage + "core.";
        String rawBody = "public static Object create(Object beanFactry, Object bean, Class[] classes, Object[] params) {{2} handler = new {2}(bean, beanFactry, classes, params);{0}Enhancer e = new {0}Enhancer();e.setUseCache(false);Class[] proxyInterfaces = new Class[bean.getClass().getInterfaces().length+1];Class[] classInterfaces = bean.getClass().getInterfaces();for (int i = 0; i < classInterfaces.length; i++) {proxyInterfaces[i] = classInterfaces[i];}proxyInterfaces[proxyInterfaces.length-1] = org.hotswap.agent.plugin.spring.getbean.SpringHotswapAgentProxy.class;e.setInterfaces(proxyInterfaces);e.setSuperclass(bean.getClass().getSuperclass());e.setNamingPolicy(new {3}());e.setCallbackType({2}.class);" + this.tryObjenesisProxyCreation(cp) + "e.setCallback(handler);return e.create();}";
        String body = rawBody.replaceAll("\\{0\\}", proxy).replaceAll("\\{1\\}", core).replaceAll("\\{2\\}", callback.getName()).replaceAll("\\{3\\}", namingPolicy.getName());
        CtMethod m = CtNewMethod.make(body, ct);
        ct.addMethod(m);
        return ct.toClass(this.loader, this.pd);
    }

    private String tryObjenesisProxyCreation(ClassPool cp) {
        if (cp.find("org.springframework.objenesis.SpringObjenesis") == null) {
            return "";
        }
        if (SpringVersion.getVersion().startsWith("4.2.6") || SpringVersion.getVersion().startsWith("4.3.0")) {
            return "";
        }
        return "org.springframework.objenesis.SpringObjenesis objenesis = new org.springframework.objenesis.SpringObjenesis();if (objenesis.isWorthTrying()) {Class proxyClass = e.createClass();Object proxyInstance = objenesis.newInstance(proxyClass, false);((org.springframework.cglib.proxy.Factory) proxyInstance).setCallbacks(new org.springframework.cglib.proxy.Callback[] {handler});return proxyInstance;}";
    }

    private Class<?> buildNamingPolicyClass(String cglibPackage, ClassPool cp) throws CannotCompileException, NotFoundException {
        CtClass ct = cp.makeClass("HotswapAgentSpringNamingPolicy" + EnhancerProxyCreater.getClassSuffix(cglibPackage));
        String core = cglibPackage + "core.";
        String originalNamingPolicy = core + "SpringNamingPolicy";
        if (cp.find(originalNamingPolicy) == null) {
            originalNamingPolicy = core + "DefaultNamingPolicy";
        }
        ct.setSuperclass(cp.get(originalNamingPolicy));
        String rawBody = "public String getClassName(String prefix, String source, Object key, {0}Predicate names) {return super.getClassName(prefix + \"$HOTSWAPAGENT_\", source, key, names);}";
        String body = rawBody.replaceAll("\\{0\\}", core);
        CtMethod m = CtNewMethod.make(body, ct);
        ct.addMethod(m);
        return ct.toClass(this.loader, this.pd);
    }

    private static String getClassSuffix(String cglibPackage) {
        return String.valueOf(cglibPackage.hashCode()).replace("-", "_");
    }

    private Class<?> buildProxyCallbackClass(String cglibPackage, ClassPool cp) throws CannotCompileException, NotFoundException {
        String proxyPackage = cglibPackage + "proxy.";
        CtClass ct = cp.makeClass("HotswapSpringCallback" + EnhancerProxyCreater.getClassSuffix(cglibPackage));
        ct.setSuperclass(cp.get(DetachableBeanHolder.class.getName()));
        ct.addInterface(cp.get(proxyPackage + "MethodInterceptor"));
        String rawBody = "public Object intercept(Object obj, java.lang.reflect.Method method, Object[] args, {0}MethodProxy proxy) throws Throwable {if(method != null && method.getName().equals(\"finalize\") && method.getParameterTypes().length == 0) {return null;}if(method != null && method.getName().equals(\"$$ha$getTarget\")) {return getTarget();}if(method != null && method.getName().equals(\"$$ha$setTarget\")) {setTarget(args[0]); return null;}return proxy.invoke(getBean(), args);}";
        String body = rawBody.replaceAll("\\{0\\}", proxyPackage);
        CtMethod m = CtNewMethod.make(body, ct);
        ct.addMethod(m);
        return ct.toClass(this.loader, this.pd);
    }

    private ClassPool getCp(ClassLoader loader) {
        ClassPool cp = new ClassPool();
        cp.appendSystemPath();
        cp.appendClassPath(new LoaderClassPath(loader));
        return cp;
    }
}

