/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.reload;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.hotswap.agent.plugin.spring.transformers.api.BeanFactoryLifecycle;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class BeanFactoryAssistant {
    private ConfigurableListableBeanFactory beanFactory;
    private AtomicInteger reloadTimes;
    private long lastReloadTime;
    private volatile boolean isReload = false;
    Map<String, String> placeHolderXmlMapping = new ConcurrentHashMap<String, String>();
    private static Map<ConfigurableListableBeanFactory, BeanFactoryAssistant> beanFactoryAssistants = new ConcurrentHashMap<ConfigurableListableBeanFactory, BeanFactoryAssistant>(4);

    public BeanFactoryAssistant(ConfigurableListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.reloadTimes = new AtomicInteger(0);
        this.lastReloadTime = System.currentTimeMillis();
        beanFactoryAssistants.put(beanFactory, this);
    }

    public static boolean existReload() {
        for (BeanFactoryAssistant assistant : beanFactoryAssistants.values()) {
            if (!assistant.isReload) continue;
            return true;
        }
        return false;
    }

    public static BeanFactoryAssistant getBeanFactoryAssistant(ConfigurableListableBeanFactory beanFactory) {
        return beanFactoryAssistants.get(beanFactory);
    }

    public static BeanFactoryAssistant getBeanFactoryAssistant(DefaultListableBeanFactory beanFactory) {
        return beanFactoryAssistants.get(beanFactory);
    }

    public static BeanFactoryAssistant getBeanFactoryAssistant(AbstractAutowireCapableBeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            return BeanFactoryAssistant.getBeanFactoryAssistant((ConfigurableListableBeanFactory)beanFactory);
        }
        return null;
    }

    public void increaseReloadTimes() {
        this.reloadTimes.incrementAndGet();
        this.lastReloadTime = System.currentTimeMillis();
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void reset() {
        this.reloadTimes.set(0);
        this.lastReloadTime = System.currentTimeMillis();
    }

    public int getReloadTimes() {
        return this.reloadTimes.get();
    }

    public long getLastReloadTime() {
        return this.lastReloadTime;
    }

    public boolean isReload() {
        return this.isReload;
    }

    public void setReload(boolean isReload) {
        this.isReload = isReload;
    }

    public boolean isDestroyedBean(String beanName) {
        if (this.beanFactory instanceof BeanFactoryLifecycle) {
            return ((BeanFactoryLifecycle)this.beanFactory).hotswapAgent$isDestroyedBean(beanName);
        }
        return false;
    }
}

