/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.reload;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.logging.AgentLogger;

public class ClassChangedCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassChangedCommand.class);
    private static final Set<String> IGNORE_PACKAGES = new HashSet<String>();
    ClassLoader appClassLoader;
    Class clazz;
    Scheduler scheduler;

    public ClassChangedCommand(ClassLoader appClassLoader, Class clazz, Scheduler scheduler) {
        this.appClassLoader = appClassLoader;
        this.clazz = clazz;
        this.scheduler = scheduler;
    }

    @Override
    public void executeCommand() {
        try {
            Class<?> targetClass = Class.forName("org.hotswap.agent.plugin.spring.reload.SpringChangedAgent", true, this.appClassLoader);
            Method targetMethod = targetClass.getDeclaredMethod("addChangedClass", Class.class);
            targetMethod.invoke(null, this.clazz);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error invoking method", e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, Spring class not found in application classloader", e);
        }
    }

    static {
        IGNORE_PACKAGES.add("org.hotswap.agent.plugin.spring.reload");
        IGNORE_PACKAGES.add("org.hotswap.agent.plugin.spring.scanner");
    }
}

