/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.reload;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.logging.AgentLogger;

public class PropertiesChangedCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PropertiesChangedCommand.class);
    ClassLoader appClassLoader;
    URL url;
    Scheduler scheduler;

    public PropertiesChangedCommand(ClassLoader appClassLoader, URL url, Scheduler scheduler) {
        this.appClassLoader = appClassLoader;
        this.url = url;
        this.scheduler = scheduler;
    }

    @Override
    public void executeCommand() {
        try {
            Class<?> clazz = Class.forName("org.hotswap.agent.plugin.spring.reload.SpringChangedAgent", true, this.appClassLoader);
            Method method = clazz.getDeclaredMethod("addChangedProperty", URL.class);
            method.invoke(null, this.url);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error invoking method", e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, Spring class not found in application classloader", e);
        }
    }
}

