/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.reload;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.core.AutowiredAnnotationProcessor;
import org.hotswap.agent.plugin.spring.core.BeanFactoryProcessor;
import org.hotswap.agent.plugin.spring.core.ConfigurationClassPostProcessorEnhance;
import org.hotswap.agent.plugin.spring.core.ResetAnnotationCache;
import org.hotswap.agent.plugin.spring.core.ResetBeanFactoryPostProcessorCaches;
import org.hotswap.agent.plugin.spring.core.ResetBeanPostProcessorCaches;
import org.hotswap.agent.plugin.spring.core.ResetRequestMappingCaches;
import org.hotswap.agent.plugin.spring.core.ResetSpringStaticCaches;
import org.hotswap.agent.plugin.spring.core.ResetTransactionAttributeCaches;
import org.hotswap.agent.plugin.spring.files.PropertyReload;
import org.hotswap.agent.plugin.spring.files.XmlBeanDefinitionScannerAgent;
import org.hotswap.agent.plugin.spring.getbean.ProxyReplacer;
import org.hotswap.agent.plugin.spring.listener.SpringEventSource;
import org.hotswap.agent.plugin.spring.reload.BeanFactoryAssistant;
import org.hotswap.agent.plugin.spring.reload.ClassChangeEvent;
import org.hotswap.agent.plugin.spring.transformers.api.BeanFactoryLifecycle;
import org.hotswap.agent.plugin.spring.utils.RegistryUtils;
import org.hotswap.agent.plugin.spring.utils.ResourceUtils;
import org.hotswap.agent.util.AnnotationHelper;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.spring.util.ClassUtils;
import org.hotswap.agent.util.spring.util.ObjectUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;

public class SpringBeanReload {
    private static AgentLogger LOGGER = AgentLogger.getLogger(SpringBeanReload.class);
    private AtomicBoolean isReloading = new AtomicBoolean(false);
    private Set<Class<?>> classes = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<URL> properties = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<URL> yamls = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<URL> xmls = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<BeanDefinitionHolder> newScanBeanDefinitions = new HashSet<BeanDefinitionHolder>();
    private Set<String> changedBeanNames = new HashSet<String>();
    Set<String> newBeanNames = new HashSet<String>();
    DefaultListableBeanFactory beanFactory;
    private final Map<String, Set<String>> dependentBeanMap;
    private Set<String> processedBeans = new HashSet<String>();
    private Set<String> destroyClasses = new HashSet<String>();
    private Set<String> beansToProcess = new HashSet<String>();
    private final BeanNameGenerator beanNameGenerator;
    private final BeanFactoryAssistant beanFactoryAssistant;

    public SpringBeanReload(DefaultListableBeanFactory beanFactory) {
        this.beanFactoryAssistant = new BeanFactoryAssistant((ConfigurableListableBeanFactory)beanFactory);
        this.beanNameGenerator = new AnnotationBeanNameGenerator();
        this.beanFactory = beanFactory;
        this.dependentBeanMap = (Map)ReflectionHelper.get(beanFactory, "dependentBeanMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(Class clazz) {
        if (clazz == null) {
            return;
        }
        String simpleName = clazz.getSimpleName();
        String userClassSimpleName = ClassUtils.getUserClass(clazz).getSimpleName();
        boolean sameClass = simpleName.equals(userClassSimpleName);
        Set<Class<?>> set = this.classes;
        synchronized (set) {
            if (this.classes.add(clazz)) {
                if (sameClass) {
                    LOGGER.debug("try to add changed class '{}' into {}", clazz.getName(), ObjectUtils.identityToString(this.beanFactory));
                } else {
                    LOGGER.debug("try to add changed class '{}({})' into {}", clazz.getName(), userClassSimpleName, ObjectUtils.identityToString(this.beanFactory));
                }
            } else if (sameClass) {
                LOGGER.debug("try to add changed class '{}' into {}, but it is exist", clazz.getName(), ObjectUtils.identityToString(this.beanFactory));
            } else {
                LOGGER.debug("try to add changed class '{}({})' into {}, but it is exist", clazz.getName(), userClassSimpleName, ObjectUtils.identityToString(this.beanFactory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(URL property) {
        if (property == null) {
            return;
        }
        Set<URL> set = this.properties;
        synchronized (set) {
            if (this.properties.add(property)) {
                LOGGER.info("try to add changed property '{}' into {}", property, ObjectUtils.identityToString(this.beanFactory));
            } else {
                LOGGER.debug("try to add changed property '{}' into {}", property, ObjectUtils.identityToString(this.beanFactory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addYaml(URL property) {
        if (property == null) {
            return;
        }
        Set<URL> set = this.yamls;
        synchronized (set) {
            if (this.yamls.add(property)) {
                LOGGER.info("try to add changed yaml '{}' into {}", property, ObjectUtils.identityToString(this.beanFactory));
            } else {
                LOGGER.debug("try to add changed yaml '{}' into {}, but exist", property, ObjectUtils.identityToString(this.beanFactory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanNewBean(BeanDefinitionRegistry registry, BeanDefinitionHolder beanDefinitionHolder) {
        if (beanDefinitionHolder == null) {
            return;
        }
        DefaultListableBeanFactory defaultListableBeanFactory = RegistryUtils.maybeRegistryToBeanFactory(registry);
        if (defaultListableBeanFactory != null && defaultListableBeanFactory.equals(this.beanFactory)) {
            Set<BeanDefinitionHolder> set = this.newScanBeanDefinitions;
            synchronized (set) {
                this.newScanBeanDefinitions.add(beanDefinitionHolder);
                LOGGER.info("add new spring bean '{}' into {}", beanDefinitionHolder.getBeanName(), ObjectUtils.identityToString(this.beanFactory));
                return;
            }
        }
        LOGGER.debug("'{}' is not '{}' or the newBean is exist, ignore it", registry, defaultListableBeanFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXml(URL xml) {
        if (xml == null) {
            return;
        }
        Set<URL> set = this.xmls;
        synchronized (set) {
            if (this.xmls.add(xml)) {
                LOGGER.info("try to add xml '{}' into {}", xml, ObjectUtils.identityToString(this.beanFactory));
            } else {
                LOGGER.debug("try to add xml '{}' into {}", xml, ObjectUtils.identityToString(this.beanFactory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangedBeanNames(String[] beanNames) {
        if (beanNames == null) {
            return;
        }
        Set<String> set = this.changedBeanNames;
        synchronized (set) {
            if (this.changedBeanNames.addAll(Arrays.asList(beanNames))) {
                LOGGER.debug("try to add changed beanNames '{}' into {}", Arrays.asList(beanNames), ObjectUtils.identityToString(this.beanFactory));
            } else {
                LOGGER.trace("try to add changed beanNames '{}' into {}, but exist", Arrays.asList(beanNames), ObjectUtils.identityToString(this.beanFactory));
            }
        }
    }

    public void collectPlaceHolderProperties() {
        String[] beanNames;
        for (String beanName : beanNames = this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            this.doCollectPlaceHolderProperties(beanName, beanDefinition);
        }
    }

    private void doCollectPlaceHolderProperties(String beanName, BeanDefinition beanDefinition) {
        if (beanDefinition.getPropertyValues() != null) {
            for (PropertyValue pv : beanDefinition.getPropertyValues().getPropertyValues()) {
                String resourcePath = this.getPlaceHolderBeanResource(pv.getValue(), beanName, beanDefinition);
                if (resourcePath == null) continue;
                this.beanFactoryAssistant.placeHolderXmlMapping.put(beanName, resourcePath);
                return;
            }
        }
        if (beanDefinition.getConstructorArgumentValues().isEmpty()) {
            return;
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : beanDefinition.getConstructorArgumentValues().getIndexedArgumentValues().values()) {
            String resourcePath = this.getPlaceHolderBeanResource(valueHolder.getValue(), beanName, beanDefinition);
            if (resourcePath == null) continue;
            this.beanFactoryAssistant.placeHolderXmlMapping.put(beanName, resourcePath);
            return;
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : beanDefinition.getConstructorArgumentValues().getGenericArgumentValues()) {
            String resourcePath = this.getPlaceHolderBeanResource(valueHolder.getValue(), beanName, beanDefinition);
            if (resourcePath == null) continue;
            this.beanFactoryAssistant.placeHolderXmlMapping.put(beanName, resourcePath);
            return;
        }
    }

    private String getPlaceHolderBeanResource(Object object, String beanName, BeanDefinition beanDefinition) {
        if (!this.isPlaceHolderBean(object)) {
            return null;
        }
        if (beanDefinition instanceof AbstractBeanDefinition) {
            return ResourceUtils.getPath(((AbstractBeanDefinition)beanDefinition).getResource());
        }
        return null;
    }

    private boolean isPlaceHolderBean(Object v) {
        String value = null;
        if (v instanceof TypedStringValue) {
            value = ((TypedStringValue)v).getValue();
        } else if (v instanceof String) {
            value = (String)v;
        }
        if (value == null) {
            return false;
        }
        return value.startsWith("${") && value.endsWith("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reload(long changeTimeStamps) {
        boolean bl;
        if (!this.preCheckReload()) {
            return false;
        }
        boolean allowBeanDefinitionOverriding = BeanFactoryProcessor.isAllowBeanDefinitionOverriding(this.beanFactory);
        long now = System.currentTimeMillis();
        ClassLoader origContextClassLoader = null;
        try {
            origContextClassLoader = ClassUtils.overrideThreadContextClassLoader(this.beanFactory.getBeanClassLoader());
            this.beanFactoryAssistant.setReload(true);
            LOGGER.debug("##### start reloading '{}' with timestamp '{}'", ObjectUtils.identityToString(this.beanFactory), changeTimeStamps);
            LOGGER.trace("SpringReload:{},  beanFactory:{}", this, this.beanFactory);
            BeanFactoryProcessor.setAllowBeanDefinitionOverriding(this.beanFactory, true);
            do {
                this.doReload();
            } while (this.checkHasChange() && this.printReloadLog());
            bl = true;
        }
        catch (Throwable throwable) {
            ClassUtils.overrideThreadContextClassLoader(origContextClassLoader);
            this.beanFactoryAssistant.increaseReloadTimes();
            BeanFactoryProcessor.setAllowBeanDefinitionOverriding(this.beanFactory, allowBeanDefinitionOverriding);
            LOGGER.debug("##### [{}th] finish reloading '{}', it cost {}ms", this.beanFactoryAssistant.getReloadTimes(), ObjectUtils.identityToString(this.beanFactory), System.currentTimeMillis() - now);
            throw throwable;
        }
        ClassUtils.overrideThreadContextClassLoader(origContextClassLoader);
        this.beanFactoryAssistant.increaseReloadTimes();
        BeanFactoryProcessor.setAllowBeanDefinitionOverriding(this.beanFactory, allowBeanDefinitionOverriding);
        LOGGER.debug("##### [{}th] finish reloading '{}', it cost {}ms", this.beanFactoryAssistant.getReloadTimes(), ObjectUtils.identityToString(this.beanFactory), System.currentTimeMillis() - now);
        return bl;
    }

    private void doReload() {
        while (true) {
            this.clearSpringCache();
            boolean propertiesChanged = this.refreshProperties();
            this.reloadXmlBeanDefinitions(propertiesChanged);
            this.refreshChangedClassesAndBeans();
            this.refreshNewBean();
            this.destroyBeans();
            if (this.checkHasChange() && this.printReloadLog()) continue;
            ProxyReplacer.clearAllProxies();
            SpringBeanReload.invokeBeanFactoryPostProcessors(this.beanFactory);
            SpringBeanReload.addBeanPostProcessors(this.beanFactory);
            this.processAutowiredAnnotationBeans();
            this.processConfigBeanDefinitions();
            if (!this.checkHasChange()) break;
        }
        this.preInstantiateSingleton();
        this.refreshRequestMapping();
        this.clearLocalCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean preCheckReload() {
        if (!this.checkHasChange()) {
            return false;
        }
        Set<Class<?>> set = this.classes;
        synchronized (set) {
            if (!this.classes.isEmpty()) {
                Iterator<Class<?>> iterator = this.classes.iterator();
                while (iterator.hasNext()) {
                    Class<?> clazz = iterator.next();
                    String[] names = this.beanFactory.getBeanNamesForType(clazz);
                    if (!(names != null && names.length != 0 || this.isFactoryMethod(clazz))) {
                        LOGGER.trace("the class '{}' is not spring bean or factory class", clazz.getName());
                        iterator.remove();
                        continue;
                    }
                    LOGGER.debug("the class '{}' is spring bean or factory class", clazz.getName());
                }
            }
        }
        return this.checkHasChange();
    }

    private boolean isFactoryMethod(Class<?> clazz) {
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            if (beanDefinition.getFactoryMethodName() == null || beanDefinition.getBeanClassName() == null || !clazz.getName().equals(beanDefinition.getBeanClassName())) continue;
            return true;
        }
        return false;
    }

    private boolean printReloadLog() {
        LOGGER.debug("the class or the file at '{}' has changes, rerun the while loop.{}", ObjectUtils.identityToString(this.beanFactory), this);
        return true;
    }

    private boolean checkHasChange() {
        if (this.properties.isEmpty() && this.classes.isEmpty() && this.xmls.isEmpty() && this.newScanBeanDefinitions.isEmpty() && this.yamls.isEmpty() && this.changedBeanNames.isEmpty()) {
            LOGGER.trace("no change, ignore reloading '{}'", ObjectUtils.identityToString(this.beanFactory));
            return false;
        }
        LOGGER.trace("has change, start reloading '{}', {}", ObjectUtils.identityToString(this.beanFactory), this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshProperties() {
        boolean propertiesChanged = false;
        Set<URL> set = this.properties;
        synchronized (set) {
            if (!this.properties.isEmpty()) {
                this.beansToProcess.addAll(this.beanFactoryAssistant.placeHolderXmlMapping.keySet());
                this.properties.clear();
                propertiesChanged = true;
            }
        }
        set = this.yamls;
        synchronized (set) {
            if (!this.yamls.isEmpty()) {
                this.yamls.clear();
                propertiesChanged = true;
            }
        }
        if (propertiesChanged) {
            LOGGER.reload("the properties of '{}' is changed", ObjectUtils.identityToString(this.beanFactory));
            PropertyReload.reloadPropertySource(this.beanFactory);
            this.beansToProcess.addAll(PropertyReload.getContainValueAnnotationBeans(this.beanFactory));
            return true;
        }
        return false;
    }

    private void reloadXmlBeanDefinitions(boolean propertiesChanged) {
        Set<String> result = XmlBeanDefinitionScannerAgent.reloadXmlsAndGetBean(this.beanFactory, propertiesChanged, this.beanFactoryAssistant.placeHolderXmlMapping, this.beansToProcess, this.xmls);
        this.processedBeans.addAll(result);
    }

    private void refreshChangedClassesAndBeans() {
        LOGGER.debug("refresh changed classes and beans of {}, classes:{}, changedBeans:{}", ObjectUtils.identityToString(this.beanFactory), this.classes, this.changedBeanNames);
        HashSet<String> configurationBeansToReload = new HashSet<String>();
        this.refreshChangedClass(configurationBeansToReload::addAll);
        this.refreshChangedBeans(configurationBeansToReload::addAll);
        this.resetConfigurationBeanDefinition(configurationBeansToReload);
        LOGGER.trace("clear class cache of {}", ObjectUtils.identityToString(this.beanFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChangedClass(Consumer<List<String>> reloadBeans) {
        HashSet classToProcess;
        Set<Class<?>> set = this.classes;
        synchronized (set) {
            classToProcess = new HashSet(this.classes);
            this.classes.clear();
        }
        for (Class clazz : classToProcess) {
            this.destroyClasses.add(ClassUtils.getUserClass(clazz).getName());
            String[] names = this.beanFactory.getBeanNamesForType(clazz);
            if (names != null && names.length > 0) {
                LOGGER.trace("the bean of class {} has the bean names {}", clazz.getName(), Arrays.asList(names));
                this.beansToProcess.addAll(Arrays.asList(names));
                reloadBeans.accept(this.reloadAnnotatedBeanDefinitions(clazz, names));
                SpringEventSource.INSTANCE.fireEvent(new ClassChangeEvent(clazz, (ConfigurableListableBeanFactory)this.beanFactory));
                continue;
            }
            LOGGER.debug("the bean of class {} not found", clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshChangedBeans(Consumer<List<String>> reloadBeans) {
        HashSet<String> beanNamesToProcess;
        Set<String> set = this.changedBeanNames;
        synchronized (set) {
            beanNamesToProcess = new HashSet<String>(this.changedBeanNames);
            this.changedBeanNames.clear();
        }
        for (String beanName : beanNamesToProcess) {
            AbstractBeanDefinition abstractBeanDefinition;
            BeanDefinition beanDefinition;
            this.beansToProcess.add(beanName);
            if (!this.beanFactory.containsBeanDefinition(beanName) || !((beanDefinition = this.beanFactory.getBeanDefinition(beanName)) instanceof AbstractBeanDefinition) || !(abstractBeanDefinition = (AbstractBeanDefinition)beanDefinition).hasBeanClass()) continue;
            Class clazz = abstractBeanDefinition.getBeanClass();
            reloadBeans.accept(this.reloadAnnotatedBeanDefinitions(clazz, new String[]{beanName}));
        }
    }

    private void resetConfigurationBeanDefinition(Set<String> configurationBeansToReload) {
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            String factoryBeanName = beanDefinition.getFactoryBeanName();
            if (factoryBeanName == null || !configurationBeansToReload.contains(factoryBeanName)) continue;
            LOGGER.debug("the bean '{}' will be recreating because the factory bean '{}' is changed", beanName, factoryBeanName);
            this.beanFactory.removeBeanDefinition(beanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNewBean() {
        HashSet<String> newBeanNames = new HashSet<String>();
        Set<BeanDefinitionHolder> set = this.newScanBeanDefinitions;
        synchronized (set) {
            for (BeanDefinitionHolder beanDefinitionHolder : this.newScanBeanDefinitions) {
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)beanDefinitionHolder, (BeanDefinitionRegistry)this.beanFactory);
                newBeanNames.add(beanDefinitionHolder.getBeanName());
                LOGGER.debug("Register new bean from scanning: {}", beanDefinitionHolder.getBeanName());
            }
            this.newScanBeanDefinitions.clear();
        }
        this.newBeanNames.addAll(newBeanNames);
    }

    private void preInstantiateSingleton() {
        LOGGER.debug("preInstantiateSingleton of {}", ObjectUtils.identityToString(this.beanFactory));
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = null;
            try {
                beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException e) {
                LOGGER.debug("bean not found: " + beanName, new Object[0]);
                continue;
            }
            if (!beanDefinition.isSingleton()) continue;
            try {
                this.beanFactory.getBean(beanName);
            }
            catch (Exception e) {
                LOGGER.error("Failed to get bean: " + beanName, e, new Object[0]);
            }
        }
    }

    private void refreshRequestMapping() {
        LOGGER.debug("refreshRequestMapping of {}", ObjectUtils.identityToString(this.beanFactory));
        ResetRequestMappingCaches.reset(this.beanFactory);
    }

    private void processAutowiredAnnotationBeans() {
        LOGGER.debug("process @Value and @Autowired of singleton beans of {}", ObjectUtils.identityToString(this.beanFactory));
        AutowiredAnnotationProcessor.processSingletonBeanInjection(this.beanFactory);
    }

    private void processConfigBeanDefinitions() {
        LOGGER.debug("process @Configuration of {}", ObjectUtils.identityToString(this.beanFactory));
        ConfigurationClassPostProcessorEnhance.getInstance((BeanDefinitionRegistry)this.beanFactory).postProcess((BeanDefinitionRegistry)this.beanFactory);
    }

    private void clearSpringCache() {
        ResetSpringStaticCaches.reset();
        ResetBeanPostProcessorCaches.reset(this.beanFactory);
        ResetTransactionAttributeCaches.reset(this.beanFactory);
        ResetBeanFactoryPostProcessorCaches.reset(this.beanFactory);
        ProxyReplacer.clearAllProxies();
        ConfigurationClassPostProcessorEnhance.getInstance((BeanDefinitionRegistry)this.beanFactory).resetConfigurationClassPostProcessor((BeanDefinitionRegistry)this.beanFactory);
        ResetAnnotationCache.resetAnnotationScanner(this.beanFactory);
    }

    private void clearLocalCache() {
        this.beansToProcess.clear();
        this.newBeanNames.clear();
        if (this.beanFactory instanceof BeanFactoryLifecycle) {
            ((BeanFactoryLifecycle)this.beanFactory).hotswapAgent$clearDestroyBean();
        }
    }

    private List<String> reloadAnnotatedBeanDefinitions(Class clazz, String[] beanNames) {
        ArrayList<String> configurationBeansToReload = new ArrayList<String>();
        Class<?> realClass = ClassUtils.getUserClass(clazz);
        for (String beanName : beanNames) {
            if (beanName.startsWith("&")) {
                beanName = beanName.substring(1);
            }
            BeanDefinition beanDefinition = BeanFactoryProcessor.getBeanDefinition((ConfigurableListableBeanFactory)this.beanFactory, beanName);
            if (!AnnotationHelper.hasAnnotation(realClass, "org.springframework.context.annotation.Configuration") || beanDefinition.getAttribute("org.springframework.context.annotation.ConfigurationClassPostProcessor.configurationClass") == null) continue;
            configurationBeansToReload.add(beanName);
            String generateBeanName = this.beanNameGenerator.generateBeanName(beanDefinition, (BeanDefinitionRegistry)this.beanFactory);
            if (!beanName.equals(generateBeanName)) {
                this.beanFactory.removeBeanDefinition(beanName);
                AnnotatedGenericBeanDefinition newBeanDefinition = new AnnotatedGenericBeanDefinition(realClass);
                this.beanFactory.registerBeanDefinition(generateBeanName, (BeanDefinition)newBeanDefinition);
                continue;
            }
            ((AbstractBeanDefinition)beanDefinition).setBeanClass(realClass);
            beanDefinition.removeAttribute("org.springframework.context.annotation.ConfigurationClassPostProcessor.configurationClass");
        }
        return configurationBeansToReload;
    }

    private void destroyBeans() {
        for (String beanName : new ArrayList<String>(this.beansToProcess)) {
            this.destroyBean(beanName);
        }
        for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            if (!this.isFactoryMethodAndNeedReload(beanName, beanDefinition)) continue;
            this.destroyBean(beanName);
        }
        this.processedBeans.clear();
        this.destroyClasses.clear();
    }

    private boolean isFactoryMethodAndNeedReload(String beanName, BeanDefinition beanDefinition) {
        if (beanDefinition.getFactoryMethodName() == null) {
            return false;
        }
        if (beanDefinition.getBeanClassName() != null && this.destroyClasses.contains(beanDefinition.getBeanClassName())) {
            LOGGER.debug("the bean '{}' of factory class '{}' is changed", beanName, beanDefinition.getBeanClassName());
            return true;
        }
        if (beanDefinition.getFactoryBeanName() != null && this.processedBeans.contains(beanDefinition.getFactoryBeanName())) {
            LOGGER.debug("the bean '{}' of factory bean '{}' is changed", beanName, beanDefinition.getFactoryBeanName());
            return true;
        }
        return false;
    }

    private void destroyBean(String beanName) {
        if (beanName != null && beanName.startsWith("&") && !this.beanFactory.containsBeanDefinition(beanName)) {
            beanName = beanName.substring(1);
        }
        if (this.processedBeans.contains(beanName)) {
            return;
        }
        Object[] dependentBeans = this.beanFactory.getDependentBeans(beanName);
        LOGGER.debug("the bean '{}' is destroyed, and it is depended by {}", beanName, Arrays.toString(dependentBeans));
        this.doDestroyBean(beanName);
    }

    private void doDestroyBean(String beanName) {
        this.processedBeans.add(beanName);
        Object singletonObject = this.beanFactory.getSingleton(beanName);
        if (singletonObject != null) {
            this.destroyClasses.add(ClassUtils.getUserClass(singletonObject).getName());
        }
        BeanFactoryProcessor.destroySingleton(this.beanFactory, beanName);
    }

    private boolean containBeanDependencyAtConstruct(Constructor<?> constructor) {
        Class<?>[] classes = constructor.getParameterTypes();
        if (classes == null || classes.length == 0) {
            return false;
        }
        for (Class<?> clazz : classes) {
            String[] beanNames;
            if (clazz.isPrimitive() || clazz == String.class || (beanNames = this.beanFactory.getBeanNamesForType(clazz)) == null || beanNames.length <= 0) continue;
            return true;
        }
        return false;
    }

    private static void invokeBeanFactoryPostProcessors(DefaultListableBeanFactory factory) {
        try {
            LOGGER.debug("try to invoke PostProcessorRegistrationDelegate", new Object[0]);
            SpringBeanReload.invokePostProcessorRegistrationDelegate(factory);
        }
        catch (ClassNotFoundException t) {
            LOGGER.debug("Failed to invoke PostProcessorRegistrationDelegate, possibly Spring version is 3.x or less, {}", t.getMessage());
            SpringBeanReload.invokeBeanFactoryPostProcessors0(factory);
        }
        catch (NoSuchMethodException t) {
            LOGGER.debug("Failed to invoke PostProcessorRegistrationDelegate, possibly Spring version is 3.x or less, {}", t.getMessage());
            SpringBeanReload.invokeBeanFactoryPostProcessors0(factory);
        }
        catch (Exception e) {
            LOGGER.error("Failed to invoke PostProcessorRegistrationDelegate", e, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    private static void invokePostProcessorRegistrationDelegate(DefaultListableBeanFactory factory) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = Class.forName("org.springframework.context.support.PostProcessorRegistrationDelegate", true, factory.getClass().getClassLoader());
        Method method = clazz.getDeclaredMethod("invokeBeanFactoryPostProcessors", ConfigurableListableBeanFactory.class, List.class);
        method.setAccessible(true);
        method.invoke(null, factory, Collections.emptyList());
    }

    private static void invokeBeanFactoryPostProcessors0(DefaultListableBeanFactory factory) {
        String[] bfppNames;
        BeanDefinitionRegistryPostProcessor pp;
        String[] bdrppNames;
        for (String name : bdrppNames = factory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false)) {
            pp = (BeanDefinitionRegistryPostProcessor)factory.getBean(name, BeanDefinitionRegistryPostProcessor.class);
            try {
                pp.postProcessBeanDefinitionRegistry((BeanDefinitionRegistry)factory);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to invoke BeanDefinitionRegistryPostProcessor: {}, reason:{}", pp.getClass().getName(), e.getMessage());
            }
            pp.postProcessBeanDefinitionRegistry((BeanDefinitionRegistry)factory);
        }
        for (String name : bdrppNames) {
            pp = (BeanDefinitionRegistryPostProcessor)factory.getBean(name, BeanDefinitionRegistryPostProcessor.class);
            try {
                pp.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to invoke BeanDefinitionRegistryPostProcessor: {}, reason:{}", pp.getClass().getName(), e.getMessage());
                LOGGER.trace("Failed to invoke BeanDefinitionRegistryPostProcessor", e, new Object[0]);
            }
        }
        for (String name : bfppNames = factory.getBeanNamesForType(BeanFactoryPostProcessor.class, true, false)) {
            if (Arrays.asList(bdrppNames).contains(name)) continue;
            BeanFactoryPostProcessor pp2 = (BeanFactoryPostProcessor)factory.getBean(name, BeanFactoryPostProcessor.class);
            try {
                pp2.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to invoke BeanDefinitionRegistryPostProcessor: {}, reason:{}", pp2.getClass().getName(), e.getMessage());
                LOGGER.trace("Failed to invoke BeanDefinitionRegistryPostProcessor", e, new Object[0]);
            }
        }
    }

    private static void addBeanPostProcessors(DefaultListableBeanFactory factory) {
        String[] names = factory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        LOGGER.debug("try to add BeanPostProcessor: {}", Arrays.asList(names));
        for (String name : names) {
            BeanPostProcessor pp = (BeanPostProcessor)factory.getBean(name, BeanPostProcessor.class);
            factory.addBeanPostProcessor(pp);
            LOGGER.trace("Add BeanPostProcessor '{}' that mapping to {}", name, ObjectUtils.identityToString(pp));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SpringBeanReload{");
        sb.append("classes=").append(this.classes);
        sb.append(", properties=").append(this.properties);
        sb.append(", yamls=").append(this.yamls);
        sb.append(", xmls=").append(this.xmls);
        sb.append(", newScanBeanDefinitions=").append(this.newScanBeanDefinitions);
        sb.append(", changedBeanNames=").append(this.changedBeanNames);
        sb.append('}');
        return sb.toString();
    }
}

