/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.scanner;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.SpringPlugin;
import org.hotswap.agent.plugin.spring.reload.SpringChangedAgent;
import org.hotswap.agent.plugin.spring.utils.RegistryUtils;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.spring.util.ObjectUtils;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class ClassPathBeanDefinitionScannerAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ClassPathBeanDefinitionScannerAgent.class);
    private static Map<ClassPathBeanDefinitionScanner, ClassPathBeanDefinitionScannerAgent> instances = new HashMap<ClassPathBeanDefinitionScanner, ClassPathBeanDefinitionScannerAgent>();
    public static boolean reloadFlag = false;
    ClassPathBeanDefinitionScanner scanner;
    Set<String> basePackages = new HashSet<String>();
    BeanDefinitionRegistry registry;
    ScopeMetadataResolver scopeMetadataResolver;
    BeanNameGenerator beanNameGenerator;
    private Set<BeanDefinition> beanDefinitions = new HashSet<BeanDefinition>();

    public static ClassPathBeanDefinitionScannerAgent getInstance(ClassPathBeanDefinitionScanner scanner) {
        ClassPathBeanDefinitionScannerAgent classPathBeanDefinitionScannerAgent = instances.get(scanner);
        if (classPathBeanDefinitionScannerAgent == null || classPathBeanDefinitionScannerAgent.registry != scanner.getRegistry()) {
            instances.put(scanner, new ClassPathBeanDefinitionScannerAgent(scanner));
        }
        return instances.get(scanner);
    }

    public static ClassPathBeanDefinitionScannerAgent getInstance(String basePackage) {
        for (ClassPathBeanDefinitionScannerAgent scannerAgent : instances.values()) {
            if (!scannerAgent.basePackages.contains(basePackage)) continue;
            return scannerAgent;
        }
        return null;
    }

    private ClassPathBeanDefinitionScannerAgent(ClassPathBeanDefinitionScanner scanner) {
        this.scanner = scanner;
        this.registry = scanner.getRegistry();
        this.scopeMetadataResolver = (ScopeMetadataResolver)ReflectionHelper.get(scanner, "scopeMetadataResolver");
        this.beanNameGenerator = (BeanNameGenerator)ReflectionHelper.get(scanner, "beanNameGenerator");
    }

    public void registerBasePackage(String basePackage) {
        this.basePackages.add(basePackage);
        PluginManagerInvoker.callPluginMethod(SpringPlugin.class, this.getClass().getClassLoader(), "registerComponentScanBasePackage", new Class[]{String.class}, new Object[]{basePackage});
    }

    public static boolean refreshClassAndCheckReload(ClassLoader appClassLoader, String basePackage, String clazzName, byte[] classDefinition) throws IOException {
        ClassPathBeanDefinitionScannerAgent scannerAgent = ClassPathBeanDefinitionScannerAgent.getInstance(basePackage);
        if (scannerAgent == null) {
            LOGGER.error("basePackage '{}' not associated with any scannerAgent", basePackage);
            return false;
        }
        return scannerAgent.createBeanDefinitionAndCheckReload(appClassLoader, clazzName, classDefinition);
    }

    boolean createBeanDefinitionAndCheckReload(ClassLoader appClassLoader, String clazzName, byte[] classDefinition) throws IOException {
        DefaultListableBeanFactory defaultListableBeanFactory = RegistryUtils.maybeRegistryToBeanFactory(this.registry);
        if (this.doProcessWhenBeanExist(defaultListableBeanFactory, appClassLoader, clazzName, classDefinition)) {
            LOGGER.debug("the class '{}' is exist at '{}', it will not create new BeanDefinition", clazzName, ObjectUtils.identityToString(defaultListableBeanFactory));
            return true;
        }
        BeanDefinition beanDefinition = this.resolveBeanDefinition(appClassLoader, classDefinition);
        if (beanDefinition == null) {
            return false;
        }
        String beanName = this.beanNameGenerator.generateBeanName(beanDefinition, this.registry);
        if (this.registry.containsBeanDefinition(beanName)) {
            LOGGER.debug("Bean definition '{}' already exists", beanName);
            return false;
        }
        this.beanDefinitions.add(beanDefinition);
        BeanDefinitionHolder beanDefinitionHolder = this.defineBean(beanDefinition);
        if (beanDefinitionHolder != null) {
            LOGGER.debug("Registering Spring bean '{}'", beanName);
            if (defaultListableBeanFactory != null) {
                SpringChangedAgent.addNewBean(beanDefinitionHolder, (ConfigurableListableBeanFactory)defaultListableBeanFactory);
                return true;
            }
        }
        return false;
    }

    private boolean doProcessWhenBeanExist(DefaultListableBeanFactory defaultListableBeanFactory, ClassLoader appClassLoader, String clazzName, byte[] classDefinition) {
        try {
            String[] beanNames;
            Class<?> clazz = this.loadClass(appClassLoader, clazzName, classDefinition);
            if (defaultListableBeanFactory != null && clazz != null && (beanNames = defaultListableBeanFactory.getBeanNamesForType(clazz)) != null && beanNames.length != 0) {
                SpringChangedAgent.addChangedClass(clazz, defaultListableBeanFactory);
                return true;
            }
        }
        catch (Exception t) {
            LOGGER.debug("make class failed", t, new Object[0]);
        }
        return false;
    }

    private Class<?> loadClass(ClassLoader appClassLoader, String clazzName, byte[] classDefinition) {
        Class<?> clazz = this.doLoadClass(appClassLoader, clazzName);
        if (clazz != null) {
            return clazz;
        }
        ClassPool pool = ClassPool.getDefault();
        try {
            CtClass ctClass = pool.makeClass(new ByteArrayInputStream(classDefinition));
            clazz = this.doLoadClass(appClassLoader, ctClass.getName());
            if (clazz != null) {
                return clazz;
            }
            return ctClass.toClass(appClassLoader, this.registry.getClass().getProtectionDomain());
        }
        catch (IOException e) {
            LOGGER.trace("make new class failed, {}", e.getMessage());
            return null;
        }
        catch (CannotCompileException e) {
            LOGGER.trace("make new class failed, {}", e.getMessage());
            return null;
        }
    }

    private Class<?> doLoadClass(ClassLoader appClassLoader, String clazzName) {
        try {
            if (clazzName == null || clazzName.isEmpty()) {
                return null;
            }
            String realClassName = clazzName.replaceAll("/", ".");
            return appClassLoader.loadClass(realClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanDefinitionHolder defineBean(BeanDefinition candidate) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            ScopeMetadata scopeMetadata = this.scopeMetadataResolver.resolveScopeMetadata(candidate);
            candidate.setScope(scopeMetadata.getScopeName());
            String beanName = this.beanNameGenerator.generateBeanName(candidate, this.registry);
            if (this.checkCandidate(beanName, candidate)) {
                BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(candidate, beanName);
                definitionHolder = this.applyScopedProxyMode(scopeMetadata, definitionHolder, this.registry);
                LOGGER.debug("Bean definition '{}'", beanName, candidate);
                return definitionHolder;
            }
            return null;
        }
    }

    private BeanDefinition resolveBeanDefinition(ClassLoader appClassLoader, byte[] bytes) throws IOException {
        ByteArrayResource resource = new ByteArrayResource(bytes);
        this.resetCachingMetadataReaderFactoryCache();
        MetadataReader metadataReader = this.getMetadataReader(appClassLoader, (Resource)resource);
        if (this.isCandidateComponent(metadataReader)) {
            ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
            sbd.setResource((Resource)resource);
            sbd.setSource((Object)resource);
            if (this.isCandidateComponent((AnnotatedBeanDefinition)sbd)) {
                LOGGER.debug("Identified candidate component class '{}'", metadataReader.getClassMetadata().getClassName());
                return sbd;
            }
            LOGGER.debug("Ignored because not a concrete top-level class '{}'", metadataReader.getClassMetadata().getClassName());
            return null;
        }
        LOGGER.debug("Ignored because not matching any filter '{}' ", metadataReader.getClassMetadata().getClassName());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataReader getMetadataReader(ClassLoader appClassLoader, Resource resource) throws IOException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(appClassLoader);
            MetadataReader metadataReader = this.getMetadataReaderFactory().getMetadataReader(resource);
            return metadataReader;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private MetadataReaderFactory getMetadataReaderFactory() {
        return (MetadataReaderFactory)ReflectionHelper.get(this.scanner, "metadataReaderFactory");
    }

    private void resetCachingMetadataReaderFactoryCache() {
        if (this.getMetadataReaderFactory() instanceof CachingMetadataReaderFactory) {
            Map metadataReaderCache = (Map)ReflectionHelper.getNoException(this.getMetadataReaderFactory(), CachingMetadataReaderFactory.class, "metadataReaderCache");
            if (metadataReaderCache == null) {
                metadataReaderCache = (Map)ReflectionHelper.getNoException(this.getMetadataReaderFactory(), CachingMetadataReaderFactory.class, "classReaderCache");
            }
            if (metadataReaderCache != null) {
                metadataReaderCache.clear();
                LOGGER.trace("Cache cleared: CachingMetadataReaderFactory.clearCache()", new Object[0]);
            } else {
                LOGGER.warning("Cache NOT cleared: neither CachingMetadataReaderFactory.metadataReaderCache nor clearCache does not exist.", new Object[0]);
            }
        }
    }

    private BeanDefinitionHolder applyScopedProxyMode(ScopeMetadata metadata, BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        return (BeanDefinitionHolder)ReflectionHelper.invoke(null, AnnotationConfigUtils.class, "applyScopedProxyMode", new Class[]{ScopeMetadata.class, BeanDefinitionHolder.class, BeanDefinitionRegistry.class}, metadata, definition, registry);
    }

    private void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        ReflectionHelper.invoke(this.scanner, ClassPathBeanDefinitionScanner.class, "registerBeanDefinition", new Class[]{BeanDefinitionHolder.class, BeanDefinitionRegistry.class}, definitionHolder, registry);
    }

    private boolean checkCandidate(String beanName, BeanDefinition candidate) {
        return (Boolean)ReflectionHelper.invoke(this.scanner, ClassPathBeanDefinitionScanner.class, "checkCandidate", new Class[]{String.class, BeanDefinition.class}, beanName, candidate);
    }

    private boolean isCandidateComponent(AnnotatedBeanDefinition sbd) {
        return (Boolean)ReflectionHelper.invoke(this.scanner, ClassPathScanningCandidateComponentProvider.class, "isCandidateComponent", new Class[]{AnnotatedBeanDefinition.class}, sbd);
    }

    private boolean isCandidateComponent(MetadataReader metadataReader) {
        return (Boolean)ReflectionHelper.invoke(this.scanner, ClassPathScanningCandidateComponentProvider.class, "isCandidateComponent", new Class[]{MetadataReader.class}, metadataReader);
    }
}

