/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.scanner;

import java.io.IOException;
import java.util.Objects;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.reload.SpringChangedReloadCommand;
import org.hotswap.agent.plugin.spring.reload.SpringReloadConfig;
import org.hotswap.agent.plugin.spring.scanner.ClassPathBeanRefreshCommand;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.util.classloader.ClassLoaderHelper;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;

public class SpringBeanWatchEventListener
implements WatchEventListener {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(SpringBeanWatchEventListener.class);
    private static final int WAIT_ON_CREATE = 600;
    private Scheduler scheduler;
    private ClassLoader appClassLoader;
    private String basePackage;

    public SpringBeanWatchEventListener(Scheduler scheduler, ClassLoader appClassLoader, String basePackage) {
        this.scheduler = scheduler;
        this.appClassLoader = appClassLoader;
        this.basePackage = basePackage;
    }

    @Override
    public void onEvent(WatchFileEvent event) {
        if (event.getEventType() == FileEvent.CREATE && event.isFile() && event.getURI().toString().endsWith(".class")) {
            String className;
            try {
                className = IOUtils.urlToClassName(event.getURI());
            }
            catch (IOException e) {
                LOGGER.trace("Watch event on resource '{}' skipped, probably Ok because of delete/create event sequence (compilation not finished yet).", e, event.getURI());
                return;
            }
            if (!ClassLoaderHelper.isClassLoaded(this.appClassLoader, className)) {
                this.scheduler.scheduleCommand(new ClassPathBeanRefreshCommand(this.appClassLoader, this.basePackage, className, event, this.scheduler), 600);
                LOGGER.trace("Scheduling Spring reload for class '{}' in classLoader {}", className, this.appClassLoader);
                this.scheduler.scheduleCommand(new SpringChangedReloadCommand(this.appClassLoader), SpringReloadConfig.reloadDelayMillis);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringBeanWatchEventListener that = (SpringBeanWatchEventListener)o;
        return Objects.equals(this.appClassLoader, that.appClassLoader) && Objects.equals(this.basePackage, that.basePackage);
    }

    public int hashCode() {
        return Objects.hash(this.appClassLoader, this.basePackage);
    }
}

