/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.transformers;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.javassist.NotFoundException;

public class ProxyReplacerTransformer {
    public static final String FACTORY_METHOD_NAME = "getBean";

    private static CtMethod overrideMethod(CtClass ctClass, CtMethod getConnectionMethodOfSuperclass) throws NotFoundException, CannotCompileException {
        CtMethod m = CtNewMethod.delegator(getConnectionMethodOfSuperclass, ctClass);
        ctClass.addMethod(m);
        return m;
    }

    @OnClassLoadEvent(classNameRegexp="org.springframework.beans.factory.support.DefaultListableBeanFactory")
    public static void replaceBeanWithProxy(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod[] methods;
        for (CtMethod ctMethod : methods = ctClass.getMethods()) {
            if (!ctMethod.getName().equals(FACTORY_METHOD_NAME)) continue;
            if (!ctClass.equals(ctMethod.getDeclaringClass())) {
                ctMethod = ProxyReplacerTransformer.overrideMethod(ctClass, ctMethod);
            }
            StringBuilder methodParamTypes = new StringBuilder();
            for (CtClass type : ctMethod.getParameterTypes()) {
                methodParamTypes.append(type.getName()).append(".class").append(", ");
            }
            ctMethod.insertAfter("if(true){return org.hotswap.agent.plugin.spring.getbean.ProxyReplacer.register($0, $_,new Class[]{" + methodParamTypes.substring(0, methodParamTypes.length() - 2) + "}, $args);}");
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.springframework.cglib.reflect.FastClass.Generator")
    public static void replaceSpringFastClassGenerator(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtConstructor[] constructors;
        for (CtConstructor ctConstructor : constructors = ctClass.getConstructors()) {
            ctConstructor.insertAfter("setUseCache(false);");
        }
    }

    @OnClassLoadEvent(classNameRegexp="net.sf.cglib.reflect.FastClass.Generator")
    public static void replaceCglibFastClassGenerator(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtConstructor[] constructors;
        for (CtConstructor ctConstructor : constructors = ctClass.getConstructors()) {
            ctConstructor.insertAfter("setUseCache(false);");
        }
    }
}

