/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.utils;

import java.io.IOException;
import java.net.URL;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.files.XmlBeanDefinitionScannerAgent;
import org.hotswap.agent.util.spring.util.StringUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ResourceUtils {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(XmlBeanDefinitionScannerAgent.class);

    public static String getPath(Resource resource) {
        String path;
        if (resource == null) {
            return null;
        }
        if (resource instanceof ClassPathResource) {
            path = ((ClassPathResource)resource).getPath();
        } else {
            if (resource instanceof ByteArrayResource) {
                LOGGER.debug("Cannot get path from ByteArrayResource: {}", new String(((ByteArrayResource)resource).getByteArray()));
                return null;
            }
            try {
                path = ResourceUtils.convertToClasspathURL(resource.getURL().getPath());
            }
            catch (IOException e) {
                LOGGER.error("Cannot get url from resource: {}", e, resource);
                return null;
            }
        }
        return path;
    }

    public static String convertToClasspathURL(String filePath) {
        String[] paths = filePath.split("src/main/resources/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("WEB-INF/classes/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("WEB-INF/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("target/classes/");
        if (paths.length == 2) {
            return paths[1];
        }
        paths = filePath.split("target/test-classes/");
        if (paths.length == 2) {
            return paths[1];
        }
        LOGGER.error("failed to convert filePath {} to classPath path", filePath);
        return filePath;
    }

    public static String convertToClasspathURL(URL[] extraClassPaths, String filePath) {
        String path = ResourceUtils.convertToClasspathURL(filePath);
        if (!StringUtils.isEmpty(path)) {
            return path;
        }
        if (extraClassPaths != null && extraClassPaths.length != 0) {
            for (URL extraClassPath : extraClassPaths) {
                String extraClassPathStr = extraClassPath.getPath();
                String[] paths = filePath.split(extraClassPathStr);
                if (paths.length != 2) continue;
                return paths[1];
            }
        }
        LOGGER.error("failed to convert filePath {} to classPath path", filePath);
        return filePath;
    }
}

