/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.vaadin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassFileEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.OnResourceFileEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.ReflectionCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;

@Plugin(name="Vaadin", description="Vaadin support", testedVersions={"23.0.0", "24.0.0.beta1"}, expectedVersions={"23 - 24"})
public class VaadinPlugin {
    static final String VAADIN_SERVLET = "com.vaadin.flow.server.VaadinServlet";
    static final String VAADIN_SERVICE = "com.vaadin.flow.server.VaadinService";
    @Init
    Scheduler scheduler;
    @Init
    ClassLoader appClassLoader;
    @Init
    PluginConfiguration pluginConfiguration;
    private boolean hasVaadinHotSwapper;
    private final Set<String> watchedPackages = new HashSet<String>();
    private Object vaadinHotswapperObj;
    private ResourceChangedCommand resourceChangedCommand;
    private UpdateRoutesCommand updateRouteRegistryCommand;
    private ReflectionCommand reloadCommand;
    private ReflectionCommand clearReflectionCache = new ReflectionCommand((Object)this, "com.vaadin.flow.internal.ReflectionCache", "clearAll");
    private Set<Class<?>> addedClasses = new HashSet();
    private Set<Class<?>> modifiedClasses = new HashSet();
    private boolean pluginReady;
    private static final AgentLogger LOGGER = AgentLogger.getLogger(VaadinPlugin.class);
    private static final String WATCHED_PACKAGES_PARAMETER = "vaadin.watched-packages";
    private static final String RELOAD_QUIET_TIME_PARAMETER = "vaadin.liveReloadQuietTime";
    private static final int DEFAULT_RELOAD_QUIET_TIME = 1000;
    private int reloadQuietTime = 0;

    @Init
    public void initPlugin() {
        String watchedPackages = this.pluginConfiguration.getProperty(WATCHED_PACKAGES_PARAMETER);
        if (watchedPackages != null) {
            Stream.of(watchedPackages.split("\\s*,\\s*")).map(String::trim).filter(pkg -> !pkg.isEmpty()).collect(Collectors.toCollection(() -> this.watchedPackages));
            LOGGER.info("Packages watched for class changes: {}", String.join((CharSequence)", ", this.watchedPackages));
        }
        this.reloadQuietTime = 1000;
        String reloadQuietTimeValue = this.pluginConfiguration.getProperty(RELOAD_QUIET_TIME_PARAMETER);
        if (reloadQuietTimeValue != null) {
            if (reloadQuietTimeValue.matches("[1-9][0-1]+")) {
                this.reloadQuietTime = Integer.parseInt(reloadQuietTimeValue);
                LOGGER.info("Live-reload quiet time is {} ms", this.reloadQuietTime);
            } else {
                LOGGER.error("Illegal value '{}' for parameter {}, using default of {} ms", reloadQuietTimeValue, RELOAD_QUIET_TIME_PARAMETER, 1000);
            }
        }
    }

    @OnClassLoadEvent(classNameRegexp="com.vaadin.flow.server.VaadinServlet")
    public static void init(CtClass ctClass, ClassPool classPool) throws NotFoundException, CannotCompileException {
        boolean hasVaadinHotSwapper = classPool.getOrNull("com.vaadin.flow.hotswap.Hotswapper") != null;
        String src = PluginManagerInvoker.buildInitializePlugin(VaadinPlugin.class);
        if (!hasVaadinHotSwapper) {
            src = src + PluginManagerInvoker.buildCallPluginMethod(VaadinPlugin.class, "registerServlet", "this", Object.class.getName());
        }
        ctClass.getDeclaredConstructor(new CtClass[0]).insertAfter(src);
        LOGGER.info("Initialized Vaadin plugin", new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp="com.vaadin.flow.server.VaadinService")
    public static void transformVaadinService(CtClass ctClass, ClassPool classPool) throws NotFoundException, CannotCompileException {
        boolean hasVaadinHotSwapper = classPool.getOrNull("com.vaadin.flow.hotswap.Hotswapper") != null;
        StringBuilder src = new StringBuilder();
        if (hasVaadinHotSwapper) {
            String initHotswapperPluginCall = PluginManagerInvoker.buildCallPluginMethod(VaadinPlugin.class, "initializeHotswapper", "hotswapper", "java.lang.Object");
            src.append("try { ").append("java.util.Optional maybeHotswapper = com.vaadin.flow.hotswap.Hotswapper.register(this);").append("if (maybeHotswapper.isPresent()) { ").append("Object hotswapper = maybeHotswapper.get();").append(initHotswapperPluginCall).append("} } catch (Exception e) { ").append("e.printStackTrace(); }");
        } else {
            src.append(PluginManagerInvoker.buildCallPluginMethod(VaadinPlugin.class, "vaadinServiceInitialized", new String[0]));
        }
        ctClass.getDeclaredMethod("init").insertBefore(src.toString());
        ctClass.getDeclaredMethod("destroy").insertBefore(PluginManagerInvoker.buildCallPluginMethod(VaadinPlugin.class, "vaadinServiceDestroyed", new String[0]));
        LOGGER.debug("{} has been enhanced.{}", VAADIN_SERVICE, hasVaadinHotSwapper ? "Vaadin Hotswapper registered" : "");
    }

    public void registerServlet(Object vaadinServlet) {
        try {
            Class<?> vaadinIntegrationClass = this.resolveClass("org.hotswap.agent.plugin.vaadin.VaadinIntegration");
            Object vaadinIntegration = vaadinIntegrationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> vaadinServletClass = this.resolveClass(VAADIN_SERVLET);
            Method m = vaadinIntegrationClass.getDeclaredMethod("servletInitialized", vaadinServletClass);
            m.invoke(vaadinIntegration, vaadinServlet);
            this.updateRouteRegistryCommand = new UpdateRoutesCommand(vaadinIntegration);
            this.reloadCommand = new ReflectionCommand(vaadinIntegration, "reload", new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            LOGGER.error(null, ex, new Object[0]);
        }
    }

    public void initializeHotswapper(Object vaadinHotswapperObj) {
        LOGGER.trace("Obtained Vaadin Hotswapper instance: {}", vaadinHotswapperObj);
        this.vaadinHotswapperObj = vaadinHotswapperObj;
        this.resourceChangedCommand = new ResourceChangedCommand(vaadinHotswapperObj);
        this.pluginReady = true;
        this.updateRouteRegistryCommand = null;
        this.reloadCommand = null;
        this.clearReflectionCache = null;
        this.addedClasses = null;
        this.modifiedClasses = null;
    }

    public void vaadinServiceInitialized() {
        this.pluginReady = true;
    }

    public void vaadinServiceDestroyed() {
        this.pluginReady = false;
    }

    private boolean isVaadin_24_5_orNewer() {
        return this.vaadinHotswapperObj != null;
    }

    private boolean isPluginReady(String message) {
        if (!this.pluginReady && LOGGER.isLevelEnabled(AgentLogger.Level.TRACE)) {
            LOGGER.trace("Plugin not ready. {}", message);
        }
        return this.pluginReady;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWatchedPackage(String packageName) {
        if (this.watchedPackages.isEmpty()) return true;
        if (!this.watchedPackages.stream().anyMatch(packageName::startsWith)) return false;
        return true;
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.DEFINE, LoadEvent.REDEFINE})
    public void onClassLoadEvent(LoadEvent event, CtClass ctClass) throws Exception {
        String className = ctClass.getName();
        if (!this.isPluginReady((Object)((Object)event) + " for class " + className)) {
            return;
        }
        if (!this.isWatchedPackage(ctClass.getPackageName())) {
            LOGGER.trace("Ignoring class {} because it is not in the watched-packages list", className);
            return;
        }
        if (this.isVaadin_24_5_orNewer()) {
            LOGGER.debug("Reloading class {} because of {}", new Object[]{className, event});
            ReflectionCommand command = new ReflectionCommand(this.vaadinHotswapperObj, "onHotswap", new String[]{className}, event == LoadEvent.REDEFINE);
            this.scheduler.scheduleCommand(command, this.reloadQuietTime);
        } else if (event == LoadEvent.REDEFINE) {
            LOGGER.debug("Redefined class {}, clearing Vaadin reflection cache and reloading browser", className);
            this.scheduler.scheduleCommand(this.clearReflectionCache);
            this.scheduler.scheduleCommand(this.reloadCommand, this.reloadQuietTime);
        }
    }

    @OnClassFileEvent(classNameRegexp=".*", events={FileEvent.CREATE, FileEvent.MODIFY})
    public void classCreated(FileEvent eventType, CtClass ctClass) throws Exception {
        if (!this.isPluginReady((Object)((Object)eventType) + " for class " + ctClass.getName())) {
            return;
        }
        if (!this.isVaadin_24_5_orNewer()) {
            if (FileEvent.CREATE.equals((Object)eventType)) {
                LOGGER.debug("Create class file event for " + ctClass.getName(), new Object[0]);
                this.addedClasses.add(this.resolveClass(ctClass.getName()));
            } else if (FileEvent.MODIFY.equals((Object)eventType)) {
                LOGGER.debug("Modify class file event for " + ctClass.getName(), new Object[0]);
                this.modifiedClasses.add(this.resolveClass(ctClass.getName()));
            }
            this.scheduler.scheduleCommand(this.updateRouteRegistryCommand);
        }
    }

    @OnResourceFileEvent(path="/")
    public void resourceChanged(URI uri, FileEvent event) {
        if (this.isVaadin_24_5_orNewer() && !uri.getPath().endsWith(".class") && this.isPluginReady((Object)((Object)event) + " for resource " + uri)) {
            LOGGER.trace("Resource {} {}", new Object[]{uri, event});
            this.resourceChangedCommand.registerEvent(event, uri);
            this.scheduler.scheduleCommand(this.resourceChangedCommand, 200);
        }
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }

    private static class ResourceChangedCommand
    extends ReflectionCommand {
        Map<FileEvent, List<URI>> changedFiles = new ConcurrentHashMap<FileEvent, List<URI>>();

        public ResourceChangedCommand(Object hotswapper) {
            super(hotswapper, "onHotswap", new Object[0]);
            this.changedFiles.put(FileEvent.CREATE, new ArrayList());
            this.changedFiles.put(FileEvent.MODIFY, new ArrayList());
            this.changedFiles.put(FileEvent.DELETE, new ArrayList());
        }

        @Override
        public List<Object> getParams() {
            List<URI> modifiedFiles = this.changedFiles.get((Object)FileEvent.MODIFY);
            this.changedFiles.get((Object)FileEvent.CREATE).removeIf(modifiedFiles::contains);
            this.changedFiles.get((Object)FileEvent.DELETE).removeIf(modifiedFiles::contains);
            ArrayList<Object> parameters = new ArrayList<Object>(3);
            parameters.add(this.changedFiles.get((Object)FileEvent.CREATE).toArray(new URI[0]));
            parameters.add(modifiedFiles.toArray(new URI[0]));
            parameters.add(this.changedFiles.get((Object)FileEvent.DELETE).toArray(new URI[0]));
            return parameters;
        }

        @Override
        public void executeCommand() {
            super.executeCommand();
            this.changedFiles.values().forEach(List::clear);
        }

        void registerEvent(FileEvent event, URI uri) {
            this.changedFiles.computeIfAbsent(event, k -> new ArrayList()).add(uri);
        }
    }

    private class UpdateRoutesCommand
    extends ReflectionCommand {
        private final Object vaadinIntegration;

        UpdateRoutesCommand(Object vaadinIntegration) {
            super(vaadinIntegration, "updateRoutes", VaadinPlugin.this.addedClasses, VaadinPlugin.this.modifiedClasses);
            this.vaadinIntegration = vaadinIntegration;
        }

        @Override
        public boolean equals(Object that) {
            return this == that;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.vaadinIntegration);
        }

        @Override
        public void executeCommand() {
            super.executeCommand();
            VaadinPlugin.this.addedClasses.clear();
            VaadinPlugin.this.modifiedClasses.clear();
        }
    }
}

