/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.wildfly.el;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;

public class PurgeWildFlyBeanELResolverCacheCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PurgeWildFlyBeanELResolverCacheCommand.class);
    private ClassLoader appClassLoader;
    private String className;

    public PurgeWildFlyBeanELResolverCacheCommand(ClassLoader appClassLoader, String className) {
        this.appClassLoader = appClassLoader;
        this.className = className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand() {
        LOGGER.info("Cleaning  BeanPropertiesCache {} {}.", this.className, this.appClassLoader);
        if (this.className != null) {
            try {
                ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.appClassLoader);
                    Class<?> cacheClazz = Class.forName("org.jboss.el.cache.BeanPropertiesCache", true, this.appClassLoader);
                    Method beanElResolverMethod = cacheClazz.getDeclaredMethod("getProperties", new Class[0]);
                    Object o = beanElResolverMethod.invoke(null, new Object[0]);
                    Map m = (Map)Map.class.cast(o);
                    Iterator it = m.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (((Class)entry.getKey()).getClassLoader() != this.appClassLoader || !((Class)entry.getKey()).getName().equals(this.className) && !((Class)entry.getKey()).getName().equals(this.className + "$Proxy$_$$_WeldSubclass")) continue;
                        it.remove();
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldContextClassLoader);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error cleaning BeanPropertiesCache. {}", e, this.className);
            }
        } else {
            Method beanElResolverMethod;
            try {
                LOGGER.info("Cleaning  BeanPropertiesCache {}.", this.appClassLoader);
                beanElResolverMethod = this.resolveClass("org.jboss.el.cache.BeanPropertiesCache").getDeclaredMethod("clear", ClassLoader.class);
                beanElResolverMethod.setAccessible(true);
                beanElResolverMethod.invoke(null, this.appClassLoader);
            }
            catch (Exception e) {
                LOGGER.error("Error cleaning BeanPropertiesCache. {}", e, this.appClassLoader);
            }
            try {
                LOGGER.info("Cleaning  FactoryFinderCache {}.", this.appClassLoader);
                beanElResolverMethod = this.resolveClass("org.jboss.el.cache.FactoryFinderCache").getDeclaredMethod("clearClassLoader", ClassLoader.class);
                beanElResolverMethod.setAccessible(true);
                beanElResolverMethod.invoke(null, this.appClassLoader);
            }
            catch (Exception e) {
                LOGGER.error("Error cleaning FactoryFinderCache. {}", e, this.appClassLoader);
            }
        }
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurgeWildFlyBeanELResolverCacheCommand that = (PurgeWildFlyBeanELResolverCacheCommand)o;
        return this.appClassLoader.equals(that.appClassLoader);
    }

    public int hashCode() {
        int result = this.appClassLoader.hashCode();
        return result;
    }

    public String toString() {
        return "PurgeWildFlyBeanELResolverCacheCommand{appClassLoader=" + this.appClassLoader + '}';
    }
}

