/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.handler.PluginAnnotation;
import org.hotswap.agent.annotation.handler.PluginClassFileTransformer;
import org.hotswap.agent.annotation.handler.PluginHandler;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.HotswapTransformer;

public class OnClassLoadedHandler
implements PluginHandler<OnClassLoadEvent> {
    protected static AgentLogger LOGGER = AgentLogger.getLogger(OnClassLoadedHandler.class);
    protected PluginManager pluginManager;
    protected HotswapTransformer hotswapTransformer;

    public OnClassLoadedHandler(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.hotswapTransformer = pluginManager.getHotswapTransformer();
        if (this.hotswapTransformer == null) {
            throw new IllegalArgumentException("Error instantiating OnClassLoadedHandler. Hotswap transformer is missing in PluginManager.");
        }
    }

    @Override
    public boolean initField(PluginAnnotation<OnClassLoadEvent> pluginAnnotation) {
        throw new IllegalAccessError("@OnClassLoadEvent annotation not allowed on fields.");
    }

    @Override
    public boolean initMethod(PluginAnnotation<OnClassLoadEvent> pluginAnnotation) {
        LOGGER.debug("Init for method " + pluginAnnotation.getMethod(), new Object[0]);
        if (this.hotswapTransformer == null) {
            LOGGER.error("Error in init for method " + pluginAnnotation.getMethod() + ". Hotswap transformer is missing.", new Object[0]);
            return false;
        }
        OnClassLoadEvent annot = pluginAnnotation.getAnnotation();
        if (annot == null) {
            LOGGER.error("Error in init for method " + pluginAnnotation.getMethod() + ". Annotation missing.", new Object[0]);
            return false;
        }
        ClassLoader appClassLoader = null;
        if (pluginAnnotation.getPlugin() != null) {
            appClassLoader = this.pluginManager.getPluginRegistry().getAppClassLoader(pluginAnnotation.getPlugin());
        }
        this.hotswapTransformer.registerTransformer(appClassLoader, annot.classNameRegexp(), new PluginClassFileTransformer(this.pluginManager, pluginAnnotation));
        return true;
    }
}

