/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.distribution;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.distribution.markdown.MarkdownProcessor;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.util.scanner.ClassPathAnnotationScanner;
import org.hotswap.agent.util.scanner.ClassPathScanner;

public class PluginDocs {
    public static final String TARGET_DIR = "/target/web-sources/";
    MarkdownProcessor markdownProcessor = new MarkdownProcessor();

    public static void main(String[] args) {
        try {
            new PluginDocs().scan();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getBaseURL(Class clazz) {
        String clazzUrl = clazz.getResource(clazz.getSimpleName() + ".class").toString();
        String classPath = clazz.getName().replace(".", "/");
        return clazzUrl.replace("/target/classes/" + classPath, "").replace(".class", "");
    }

    public void scan() throws Exception {
        StringBuilder html = new StringBuilder();
        this.addHtmlHeader(html);
        ClassPathAnnotationScanner scanner = new ClassPathAnnotationScanner(Plugin.class.getName(), new ClassPathScanner());
        for (String plugin : scanner.scanPlugins(this.getClass().getClassLoader(), "org.hotswap.agent.plugin".replace(".", "/"))) {
            Class<?> pluginClass = Class.forName(plugin);
            Plugin pluginAnnotation = pluginClass.getAnnotation(Plugin.class);
            String pluginName = pluginAnnotation.name();
            String pluginDocFile = "plugin/" + pluginName + ".html";
            String pluginLink = "ha-plugins/" + pluginName.toLowerCase() + "-plugin";
            URL url = new URL(PluginDocs.getBaseURL(this.getClass()) + TARGET_DIR + pluginDocFile);
            boolean docExists = this.markdownProcessor.processPlugin(pluginClass, url);
            this.addHtmlRow(html, pluginAnnotation, docExists ? pluginLink : null);
        }
        this.addHtmlFooter(html);
        this.writeHtml(new URL(PluginDocs.getBaseURL(this.getClass()) + TARGET_DIR + "plugins.html"), html.toString());
        String mainReadme = this.markdownProcessor.markdownToHtml(IOUtils.streamToString(new URL(PluginDocs.getBaseURL(this.getClass()) + "/../README.md").openStream()));
        this.writeMainReadme(mainReadme);
    }

    private void writeMainReadme(String mainReadme) throws MalformedURLException {
        this.writeHtml(new URL(PluginDocs.getBaseURL(this.getClass()) + TARGET_DIR + "README.html"), mainReadme);
        for (String section : mainReadme.split("\\<h1\\>")) {
            int h1EndIndex;
            if (section.isEmpty() || (h1EndIndex = section.indexOf("</h1>")) <= 0) continue;
            String label = section.substring(0, h1EndIndex);
            String content = section.substring(h1EndIndex + 5);
            label = label.replaceAll("\\s", "-");
            label = label.replaceAll("[^A-Za-z0-9-]", "");
            label = label.toLowerCase();
            this.writeHtml(new URL(PluginDocs.getBaseURL(this.getClass()) + TARGET_DIR + "section/" + label + ".html"), content);
        }
    }

    private void addHtmlRow(StringBuilder html, Plugin annot, String pluginDocFile) {
        html.append("<tr>");
        html.append("<td>");
        html.append(annot.name());
        html.append("</td>");
        html.append("<td>");
        html.append(annot.description());
        html.append("</td>");
        html.append("<td>");
        this.commaSeparated(html, annot.testedVersions());
        html.append("</td>");
        html.append("<td>");
        this.commaSeparated(html, annot.expectedVersions());
        html.append("</td>");
        html.append("<td>");
        if (pluginDocFile != null) {
            html.append("<a href='");
            html.append(pluginDocFile);
            html.append("'>Documentation</a>");
        }
        html.append("</td>");
        html.append("</tr>");
    }

    private void addHtmlHeader(StringBuilder html) {
        html.append("<table>");
    }

    private void addHtmlFooter(StringBuilder html) {
        html.append("</table>");
    }

    private void commaSeparated(StringBuilder html, String[] strings) {
        boolean first = true;
        for (String s : strings) {
            if (!first) {
                html.append(", ");
            }
            html.append(s);
            first = false;
        }
    }

    private void writeHtml(URL url, String html) {
        try {
            PluginDocs.assertDirExists(url);
            PrintWriter out = new PrintWriter(url.getFile());
            out.print(html);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Unable to open file " + url + " to write HTML content.");
        }
    }

    public static void assertDirExists(URL targetFile) {
        File parent = null;
        try {
            parent = new File(targetFile.toURI()).getParentFile();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalStateException("Couldn't create dir: " + parent);
        }
    }
}

