/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.logging;

import java.util.HashMap;
import java.util.Map;
import org.hotswap.agent.logging.AgentLoggerHandler;

public class AgentLogger {
    private static Map<String, Level> currentLevels = new HashMap<String, Level>();
    private static Level rootLevel = Level.INFO;
    private static AgentLoggerHandler handler = new AgentLoggerHandler();
    private Class clazz;

    public static AgentLogger getLogger(Class clazz) {
        return new AgentLogger(clazz);
    }

    public static void setLevel(String classPrefix, Level level) {
        currentLevels.put(classPrefix, level);
    }

    public static void setLevel(Level level) {
        rootLevel = level;
    }

    public static void setHandler(AgentLoggerHandler handler) {
        AgentLogger.handler = handler;
    }

    public static AgentLoggerHandler getHandler() {
        return handler;
    }

    public static void setDateTimeFormat(String dateTimeFormat) {
        handler.setDateTimeFormat(dateTimeFormat);
    }

    private AgentLogger(Class clazz) {
        this.clazz = clazz;
    }

    public boolean isLevelEnabled(Level level) {
        Level classLevel = rootLevel;
        String className = this.clazz.getName();
        String longestPrefix = "";
        for (String classPrefix : currentLevels.keySet()) {
            if (!className.startsWith(classPrefix) || classPrefix.length() <= longestPrefix.length()) continue;
            longestPrefix = classPrefix;
            classLevel = currentLevels.get(classPrefix);
        }
        for (Level l : Level.values()) {
            if (l == level) {
                return true;
            }
            if (l != classLevel) continue;
            return false;
        }
        throw new IllegalArgumentException("Should not happen.");
    }

    public void log(Level level, String message, Throwable throwable, Object ... args) {
        if (this.isLevelEnabled(level)) {
            handler.print(this.clazz, level, message, throwable, args);
        }
    }

    public void log(Level level, String message, Object ... args) {
        this.log(level, message, null, args);
    }

    public void error(String message, Object ... args) {
        this.log(Level.ERROR, message, args);
    }

    public void error(String message, Throwable throwable, Object ... args) {
        this.log(Level.ERROR, message, throwable, args);
    }

    public void reload(String message, Object ... args) {
        this.log(Level.RELOAD, message, args);
    }

    public void reload(String message, Throwable throwable, Object ... args) {
        this.log(Level.RELOAD, message, throwable, args);
    }

    public void warning(String message, Object ... args) {
        this.log(Level.WARNING, message, args);
    }

    public void warning(String message, Throwable throwable, Object ... args) {
        this.log(Level.WARNING, message, throwable, args);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    public void info(String message, Throwable throwable, Object ... args) {
        this.log(Level.INFO, message, throwable, args);
    }

    public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    public void debug(String message, Throwable throwable, Object ... args) {
        this.log(Level.DEBUG, message, throwable, args);
    }

    public void trace(String message, Object ... args) {
        this.log(Level.TRACE, message, args);
    }

    public void trace(String message, Throwable throwable, Object ... args) {
        this.log(Level.TRACE, message, throwable, args);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARNING);
    }

    public static enum Level {
        ERROR,
        RELOAD,
        WARNING,
        INFO,
        DEBUG,
        TRACE;

    }
}

