/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike_jakarta.DeltaspikeClassSignatureHelper;
import org.hotswap.agent.plugin.deltaspike_jakarta.command.PartialBeanClassRefreshCommand;
import org.hotswap.agent.plugin.deltaspike_jakarta.command.RepositoryRefreshCommand;
import org.hotswap.agent.plugin.deltaspike_jakarta.transformer.DeltaSpikeProxyTransformer;
import org.hotswap.agent.plugin.deltaspike_jakarta.transformer.DeltaspikeContextsTransformer;
import org.hotswap.agent.plugin.deltaspike_jakarta.transformer.PartialBeanExtensionTransformer;
import org.hotswap.agent.plugin.deltaspike_jakarta.transformer.RepositoryTransformer;
import org.hotswap.agent.util.AnnotationHelper;

@Plugin(name="DeltaspikeJakarta", description="Apache DeltaSpike (http://deltaspike.apache.org/), support repository reloading", testedVersions={"2.0.0"}, expectedVersions={"2.0.x"}, supportClass={DeltaSpikeProxyTransformer.class, PartialBeanExtensionTransformer.class, RepositoryTransformer.class, DeltaspikeContextsTransformer.class})
public class DeltaSpikeJakartaPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(DeltaSpikeJakartaPlugin.class);
    private static final String REPOSITORY_ANNOTATION = "org.apache.deltaspike.data.api.Repository";
    public static final int WAIT_ON_REDEFINE = 500;
    @Init
    ClassLoader appClassLoader;
    @Init
    Scheduler scheduler;
    @Init
    PluginConfiguration pluginConfiguration;
    boolean initialized = false;
    int waitOnRedefine = 500;
    Map<Class, Boolean> registeredPartialBeanClasses = new WeakHashMap<Class, Boolean>();
    Map<Object, String> registeredRepoProxies = new WeakHashMap<Object, String>();
    List<Class<?>> repositoryClasses;

    @Init
    public void init(PluginConfiguration pluginConfiguration) {
        if (!this.initialized) {
            LOGGER.info("DeltaspikeJakarta plugin initialized.", new Object[0]);
            this.initialized = true;
            this.waitOnRedefine = Integer.valueOf(pluginConfiguration.getProperty("deltaspike.waitOnRedefine", String.valueOf(500)));
        }
    }

    public void registerRepositoryClasses(List<Class<?>> repositoryClassesList) {
        this.repositoryClasses = new ArrayList(repositoryClassesList);
    }

    public void registerRepoProxy(Object repoProxy, Class<?> repositoryClass) {
        Class<?> checkedClass;
        if (this.repositoryClasses == null) {
            return;
        }
        if (!this.registeredRepoProxies.containsKey(repoProxy)) {
            LOGGER.debug("DeltaspikeJakartaPlugin - repository proxy registered : {}", repositoryClass.getName());
        }
        for (checkedClass = repositoryClass; checkedClass != null && !this.repositoryClasses.contains(checkedClass); checkedClass = checkedClass.getSuperclass()) {
        }
        if (checkedClass != null) {
            this.registeredRepoProxies.put(repoProxy, repositoryClass.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPartialBean(Class<?> partialBeanClass) {
        Map<Class, Boolean> map = this.registeredPartialBeanClasses;
        synchronized (map) {
            this.registeredPartialBeanClasses.put(partialBeanClass, Boolean.TRUE);
        }
        LOGGER.debug("Partial bean '{}' registered", partialBeanClass.getName());
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void classReload(CtClass clazz, Class original, ClassPool classPool) throws NotFoundException {
        PartialBeanClassRefreshCommand cmd = this.checkRefreshPartialBean(clazz, original);
        if (cmd != null) {
            this.checkRefreshRepository(clazz, classPool, cmd);
        }
    }

    private PartialBeanClassRefreshCommand checkRefreshPartialBean(CtClass clazz, Class original) throws NotFoundException {
        PartialBeanClassRefreshCommand cmd = null;
        if (this.registeredPartialBeanClasses.containsKey(original)) {
            String oldSignForProxyCheck = DeltaspikeClassSignatureHelper.getSignaturePartialBeanClass(original);
            cmd = new PartialBeanClassRefreshCommand(this.appClassLoader, original, oldSignForProxyCheck, this.scheduler);
            this.scheduler.scheduleCommand(cmd, this.waitOnRedefine);
        }
        return cmd;
    }

    private void checkRefreshRepository(CtClass clazz, ClassPool classPool, PartialBeanClassRefreshCommand masterCmd) throws NotFoundException {
        if (this.isRepository(clazz, classPool)) {
            RepositoryRefreshCommand cmd = null;
            if (this.repositoryClasses != null) {
                cmd = new RepositoryRefreshCommand(this.appClassLoader, clazz.getName(), this.getRepositoryProxies(clazz.getName()));
            }
            if (cmd != null) {
                masterCmd.addChainedCommand(cmd);
            }
        }
    }

    private List<Object> getRepositoryProxies(String repositoryClassName) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, String> entry : this.registeredRepoProxies.entrySet()) {
            if (!repositoryClassName.equals(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isRepository(CtClass clazz, ClassPool classPool) throws NotFoundException {
        if (this.isSyntheticCdiClass(clazz.getName())) {
            return false;
        }
        CtClass ctInvocationHandler = classPool.get("java.lang.reflect.InvocationHandler");
        if (clazz.subtypeOf(ctInvocationHandler)) {
            return false;
        }
        if (AnnotationHelper.hasAnnotation(clazz, REPOSITORY_ANNOTATION)) {
            return true;
        }
        CtClass superClass = clazz.getSuperclass();
        if (superClass != null) {
            return this.isRepository(superClass, classPool);
        }
        return false;
    }

    private Object getObjectByName(Map<Object, String> registeredComponents, String className) {
        for (Map.Entry<Object, String> entry : registeredComponents.entrySet()) {
            if (!className.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean isSyntheticCdiClass(String className) {
        return className.contains("$$");
    }
}

