/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta.command;

import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.reflect.Method;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.partialbean.impl.PartialBeanProxyFactory;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike_jakarta.DeltaspikeClassSignatureHelper;
import org.hotswap.agent.plugin.deltaspike_jakarta.command.ProxyClassLoadingDelegate;

public class PartialBeanClassRefreshAgent {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PartialBeanClassRefreshAgent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshPartialBeanClass(ClassLoader classLoader, Class<?> beanClass, String oldSignaturesForProxyCheck) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        String newClassSignature = DeltaspikeClassSignatureHelper.getSignaturePartialBeanClass(beanClass);
        if (newClassSignature != null && newClassSignature.equals(oldSignaturesForProxyCheck)) {
            return;
        }
        ProxyClassLoadingDelegate.beginProxyRegeneration();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            PartialBeanProxyFactory proxyFactory = PartialBeanProxyFactory.getInstance();
            Method m = PartialBeanProxyFactory.class.getMethod("getProxyClass", BeanManager.class, Class.class);
            m.invoke((Object)proxyFactory, BeanManagerProvider.getInstance().getBeanManager(), beanClass);
        }
        catch (Exception e) {
            LOGGER.error("Deltaspike proxy redefinition failed", e, new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            ProxyClassLoadingDelegate.endProxyRegeneration();
        }
    }
}

