/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta.command;

import java.security.ProtectionDomain;
import java.util.HashMap;
import org.apache.deltaspike.core.util.ClassUtils;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;

public class ProxyClassLoadingDelegate {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ProxyClassLoadingDelegate.class);
    private static final ThreadLocal<Boolean> MAGIC_IN_PROGRESS = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public static final void beginProxyRegeneration() {
        MAGIC_IN_PROGRESS.set(true);
    }

    public static final void endProxyRegeneration() {
        MAGIC_IN_PROGRESS.remove();
    }

    public static Class<?> tryToLoadClassForName(String proxyClassName, Class<?> targetClass, ClassLoader classLoader) {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            return null;
        }
        return (Class)ReflectionHelper.invoke(null, ClassUtils.class, "tryToLoadClassForName", new Class[]{String.class, Class.class, ClassLoader.class}, proxyClassName, targetClass, classLoader);
    }

    public static Class<?> loadClass(ClassLoader loader, String className, byte[] bytes, ProtectionDomain protectionDomain) {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            try {
                Class<?> originalProxyClass = loader.loadClass(className);
                try {
                    HashMap reloadMap = new HashMap();
                    reloadMap.put(originalProxyClass, bytes);
                    PluginManager.getInstance().hotswap(reloadMap);
                    return originalProxyClass;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (ClassNotFoundException originalProxyClass) {
                // empty catch block
            }
        }
        try {
            Class<?> proxyClassGeneratorClass = loader.loadClass("org.apache.deltaspike.proxy.impl.AsmDeltaSpikeProxyClassGenerator");
            if (proxyClassGeneratorClass != null) {
                return (Class)ReflectionHelper.invoke(null, proxyClassGeneratorClass, "loadClass", new Class[]{ClassLoader.class, String.class, byte[].class, ProtectionDomain.class}, loader, className, bytes, protectionDomain);
            }
        }
        catch (Exception e) {
            LOGGER.error("loadClass() exception {}", e.getMessage());
        }
        return null;
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] bytes, Class<?> originalClass, ProtectionDomain protectionDomain) {
        if (MAGIC_IN_PROGRESS.get().booleanValue()) {
            try {
                Class<?> originalProxyClass = loader.loadClass(className);
                try {
                    HashMap reloadMap = new HashMap();
                    reloadMap.put(originalProxyClass, bytes);
                    PluginManager.getInstance().hotswap(reloadMap);
                    return originalProxyClass;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (ClassNotFoundException originalProxyClass) {
                // empty catch block
            }
        }
        try {
            Class<?> classDefiner = loader.loadClass("org.apache.deltaspike.proxy.impl.ClassDefiner");
            if (classDefiner != null) {
                return (Class)ReflectionHelper.invoke(null, classDefiner, "defineClass", new Class[]{ClassLoader.class, String.class, byte[].class, Class.class, ProtectionDomain.class}, loader, className, bytes, originalClass, protectionDomain);
            }
        }
        catch (Exception e) {
            LOGGER.error("loadClass() exception {}", e.getMessage());
        }
        return null;
    }
}

