/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta.command;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.deltaspike_jakarta.command.RepositoryRefreshAgent;

public class RepositoryRefreshCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(RepositoryRefreshCommand.class);
    ClassLoader appClassLoader;
    String repoClassName;
    private List<Object> repositoryProxies;

    public RepositoryRefreshCommand(ClassLoader appClassLoader, String repoClassName, List<Object> repositoryProxies) {
        this.appClassLoader = appClassLoader;
        this.repoClassName = repoClassName;
        this.repositoryProxies = repositoryProxies;
    }

    @Override
    public void executeCommand() {
        this.refreshRepository();
    }

    private Class<?> resolveClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.appClassLoader);
    }

    private void refreshRepository() {
        try {
            LOGGER.debug("Executing RepositoryRefreshAgent.refreshHandler('{}')", this.repoClassName);
            Class<?> agentClazz = Class.forName(RepositoryRefreshAgent.class.getName(), true, this.appClassLoader);
            Method agentMethod = agentClazz.getDeclaredMethod("refreshHandler", ClassLoader.class, String.class, List.class);
            agentMethod.invoke(null, this.appClassLoader, this.repoClassName, this.repositoryProxies);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Plugin error, method not found", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("Error refreshing handler {} in appClassLoader {}", e, this.repoClassName, this.appClassLoader);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Plugin error, illegal access", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Plugin error, CDI class not found in classloader", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryRefreshCommand that = (RepositoryRefreshCommand)o;
        if (!this.appClassLoader.equals(that.appClassLoader)) {
            return false;
        }
        return this.repoClassName.equals(that.repoClassName);
    }

    public int hashCode() {
        int result = this.appClassLoader.hashCode();
        result = 31 * result + this.repoClassName.hashCode();
        return result;
    }

    public String toString() {
        return "PartialBeanClassRefreshCommand{appClassLoader=" + this.appClassLoader + "repoClassName=" + this.repoClassName + '}';
    }
}

