/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.deltaspike_jakarta.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtNewMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.deltaspike_jakarta.transformer.HaAfteBeanDiscovery;

public class RepositoryTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(RepositoryTransformer.class);
    public static final String REINITIALIZE_METHOD = "$$ha$reinitialize";

    @OnClassLoadEvent(classNameRegexp="org.apache.deltaspike.data.impl.meta.RepositoryMetadataHandler")
    public static void patchRepositoryMetadataHandler(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException {
        if (!HaCdiCommons.isJakarta(classPool)) {
            return;
        }
        ctClass.addMethod(CtNewMethod.make("public void $$ha$reinitialize(java.lang.Class repositoryClass) {org.apache.deltaspike.data.impl.meta.RepositoryMetadata metadata = metadataInitializer.init(repositoryClass, this.beanManager);this.repositoriesMetadata.put(repositoryClass, metadata);}", ctClass));
        LOGGER.debug("org.apache.deltaspike.data.impl.meta.RepositoryMetadataHandler - registration hook and reinitialization method added.", new Object[0]);
    }

    @OnClassLoadEvent(classNameRegexp="org.apache.deltaspike.data.impl.RepositoryExtension")
    public static void patchRepositoryExtension(ClassPool classPool, CtClass ctClass) throws CannotCompileException, NotFoundException, CannotCompileException {
        if (!HaCdiCommons.isJakarta(classPool)) {
            return;
        }
        if (ctClass.getSuperclassName().equals(Object.class.getName())) {
            ctClass.setSuperclass(classPool.get(HaAfteBeanDiscovery.class.getName()));
        } else {
            LOGGER.error("org.apache.deltaspike.data.impl.RepositoryExtension patch failed. Expected superclass java.lang.Object, found:" + ctClass.getSuperclassName(), new Object[0]);
        }
        LOGGER.debug("org.apache.deltaspike.data.impl.RepositoryExtension - registration hook and registration repository classes added.", new Object[0]);
    }
}

