/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.elresolver;

import java.lang.reflect.Method;
import java.util.Set;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.logging.AgentLogger;

public class PurgeBeanELResolverCacheCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(PurgeBeanELResolverCacheCommand.class);
    private ClassLoader appClassLoader;
    private final String rootPackage;
    private Set<Object> registeredBeanELResolvers;

    public PurgeBeanELResolverCacheCommand(ClassLoader appClassLoader, String rootPackage, Set<Object> registeredBeanELResolvers) {
        this.appClassLoader = appClassLoader;
        this.rootPackage = rootPackage;
        this.registeredBeanELResolvers = registeredBeanELResolvers;
    }

    @Override
    public void executeCommand() {
        LOGGER.debug("Purging BeanELResolver cache.", new Object[0]);
        try {
            Class<?> beanElResolverClass = Class.forName(this.rootPackage + ".el.BeanELResolver", true, this.appClassLoader);
            Method beanElResolverMethod = beanElResolverClass.getDeclaredMethod("$$ha$resetCache", ClassLoader.class);
            for (Object registeredBeanELResolver : this.registeredBeanELResolvers) {
                beanElResolverMethod.invoke(registeredBeanELResolver, this.appClassLoader);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("BeanELResolver class not found in class loader {}.", this.appClassLoader);
        }
        catch (Exception e) {
            LOGGER.error("Error purging BeanELResolver cache.", e, new Object[0]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PurgeBeanELResolverCacheCommand that = (PurgeBeanELResolverCacheCommand)o;
        return this.appClassLoader.equals(that.appClassLoader);
    }

    public int hashCode() {
        int result = this.appClassLoader.hashCode();
        return result;
    }

    public String toString() {
        return "PurgeBeanELResolverCacheCommand{appClassLoader=" + this.appClassLoader + '}';
    }
}

