/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.hibernate3.session.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.SessionFactoryImpl;
import org.hotswap.agent.javassist.util.proxy.MethodHandler;
import org.hotswap.agent.javassist.util.proxy.Proxy;
import org.hotswap.agent.javassist.util.proxy.ProxyFactory;
import org.hotswap.agent.plugin.hibernate3.session.proxy.ReInitializable;
import sun.reflect.ReflectionFactory;

public class SessionFactoryProxy {
    private static Map<Configuration, SessionFactoryProxy> proxiedFactories = new HashMap<Configuration, SessionFactoryProxy>();
    private Configuration configuration;
    private volatile SessionFactory currentInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionFactoryProxy getWrapper(Configuration configuration) {
        Map<Configuration, SessionFactoryProxy> map = proxiedFactories;
        synchronized (map) {
            if (!proxiedFactories.containsKey(configuration)) {
                proxiedFactories.put(configuration, new SessionFactoryProxy(configuration));
            }
            return proxiedFactories.get(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshProxiedFactories() {
        Map<Configuration, SessionFactoryProxy> map = proxiedFactories;
        synchronized (map) {
            for (SessionFactoryProxy wrapper : proxiedFactories.values()) {
                try {
                    wrapper.refreshProxiedFactory();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private SessionFactoryProxy(Configuration configuration) {
        this.configuration = configuration;
    }

    public void refreshProxiedFactory() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ReInitializable r = (ReInitializable)ReInitializable.class.cast(this.configuration);
        r.hotSwap();
        this.currentInstance = r._buildSessionFactory();
    }

    public SessionFactory proxy(SessionFactory sessionFactory) {
        try {
            Object instance;
            this.currentInstance = sessionFactory;
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(SessionFactoryImpl.class);
            factory.setInterfaces(new Class[]{SessionFactory.class, SessionFactoryImplementor.class});
            MethodHandler handler = new MethodHandler(){

                @Override
                public Object invoke(Object self, Method overridden, Method forwarder, Object[] args) throws Throwable {
                    return overridden.invoke((Object)SessionFactoryProxy.this.currentInstance, args);
                }
            };
            try {
                Constructor<?> constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(factory.createClass(), Object.class.getDeclaredConstructor(new Class[0]));
                instance = constructor.newInstance(new Object[0]);
                ((Proxy)instance).setHandler(handler);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error("Unable instantiate SessionFactory proxy", e);
            }
            return (SessionFactory)instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Unable instantiate SessionFactory proxy", e);
        }
    }
}

