/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.logback;

import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;
import org.hotswap.agent.watch.Watcher;

@Plugin(name="Logback", description="Logback configuration reload.", testedVersions={"1.0.6"})
public class LogbackPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(LogbackPlugin.class);
    @Init
    Watcher watcher;
    @Init
    ClassLoader appClassLoader;
    Set<URI> registeredURIs = new HashSet<URI>();
    boolean initialized;

    public void initLogback(final Object configurator, final URL url) {
        try {
            URI uri = url.toURI();
            if (this.registeredURIs.contains(uri)) {
                return;
            }
            LOGGER.debug("Watching '{}' URL for Logback configuration changes.", url);
            this.registeredURIs.add(uri);
            this.watcher.addEventListener(this.appClassLoader, uri, new WatchEventListener(){

                @Override
                public void onEvent(WatchFileEvent event) {
                    if (event.getEventType() != FileEvent.DELETE) {
                        LogbackPlugin.this.reload(configurator, url);
                    }
                }
            });
            if (!this.initialized) {
                LOGGER.info("Logback plugin initialized.", new Object[0]);
                this.initialized = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception initializing logback configurator {} on url {}.", e, configurator, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reload(Object configurator, URL url) {
        try {
            IOUtils.toByteArray(url.toURI());
        }
        catch (Exception e) {
            LOGGER.warning("Unable to open logback configuration file {}, is it deleted?", url);
            return;
        }
        try {
            Object e = configurator;
            synchronized (e) {
                ClassLoader classLoader = configurator.getClass().getClassLoader();
                Class<?> configuratorClass = classLoader.loadClass("ch.qos.logback.core.joran.GenericConfigurator");
                Class<?> contextAwareBaseClass = classLoader.loadClass("ch.qos.logback.core.spi.ContextAwareBase");
                Class<?> contextClass = classLoader.loadClass("ch.qos.logback.classic.LoggerContext");
                Object context = contextAwareBaseClass.getDeclaredMethod("getContext", new Class[0]).invoke(configurator, new Object[0]);
                contextClass.getDeclaredMethod("reset", new Class[0]).invoke(context, new Object[0]);
                configuratorClass.getDeclaredMethod("doConfigure", URL.class).invoke(configurator, url);
                LOGGER.reload("Logback configuration reloaded from url '{}'.", url);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to reload {} with logback configurator {}", e, url, configurator);
        }
    }

    @OnClassLoadEvent(classNameRegexp="ch.qos.logback.core.joran.GenericConfigurator")
    public static void registerConfigurator(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtMethod m = ctClass.getDeclaredMethod("doConfigure", new CtClass[]{classPool.get("java.net.URL")});
        m.insertAfter(PluginManagerInvoker.buildInitializePlugin(LogbackPlugin.class));
        m.insertAfter(PluginManagerInvoker.buildCallPluginMethod(LogbackPlugin.class, "initLogback", "this", "java.lang.Object", "url", "java.net.URL"));
    }
}

