/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.osgiequinox;

import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.hotswap.agent.annotation.Init;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.config.PluginConfiguration;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtConstructor;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.PluginManagerInvoker;
import org.hotswap.agent.util.classloader.ClassLoaderHelper;
import org.hotswap.agent.watch.WatchEventListener;
import org.hotswap.agent.watch.WatchFileEvent;
import org.hotswap.agent.watch.Watcher;

@Plugin(name="OsgiEquinox", description="Supports hotswapping in OSGI/Equinox class loader so it can be used for hotswap support in Eclipse RCP plugin development. ", testedVersions={""}, expectedVersions={""})
public class OsgiEquinoxPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(OsgiEquinoxPlugin.class);
    @Init
    Scheduler scheduler;
    @Init
    PluginManager pluginManager;
    @Init
    PluginConfiguration pluginConfiguration;
    @Init
    Watcher watcher;
    final Map<Class<?>, byte[]> reloadMap = new HashMap();
    private AutoHotswapPathEventListener listener;
    private Set<ClassLoader> registeredEquinoxClassLoaders = Collections.newSetFromMap(new WeakHashMap());
    private Command hotswapCommand;
    private String extraClasspath;
    private boolean isDebugMode;

    @OnClassLoadEvent(classNameRegexp="org.eclipse.osgi.launch.Equinox")
    public static void patchEquinox(CtClass ctClass) throws CannotCompileException {
        String initializePlugin = PluginManagerInvoker.buildInitializePlugin(OsgiEquinoxPlugin.class);
        String initializeThis = PluginManagerInvoker.buildCallPluginMethod(OsgiEquinoxPlugin.class, "initOsgiEquinox", new String[0]);
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(initializePlugin);
            constructor.insertAfter(initializeThis);
        }
    }

    public void initOsgiEquinox() {
        if (this.hotswapCommand != null) {
            return;
        }
        LOGGER.debug("Init OsgiEquinoxPlugin.", new Object[0]);
        this.extraClasspath = this.pluginConfiguration.getProperty("extraClasspath");
        if (this.extraClasspath != null) {
            String debugMode = this.pluginConfiguration.getProperty("osgiEquinox.debugMode");
            this.isDebugMode = "true".equals(debugMode);
            if (!this.isDebugMode) {
                URL resource = null;
                try {
                    resource = this.resourceNameToURL(this.extraClasspath.trim());
                    URI uri = resource.toURI();
                    LOGGER.info("Initialize hotswap on URL {}.", uri);
                    this.listener = new AutoHotswapPathEventListener(this);
                    this.watcher.addEventListener(null, uri, (WatchEventListener)this.listener);
                }
                catch (URISyntaxException e) {
                    LOGGER.error("Unable to watch path '{}' for changes.", e, resource);
                }
                catch (Exception e) {
                    LOGGER.warning("initOsgiEquinox() exception : {}", e.getMessage());
                }
                if (resource != null) {
                    this.hotswapCommand = new Command(){

                        @Override
                        public void executeCommand() {
                            OsgiEquinoxPlugin.this.pluginManager.hotswap(OsgiEquinoxPlugin.this.reloadMap);
                        }

                        public String toString() {
                            return "pluginManager.hotswap(" + Arrays.toString(OsgiEquinoxPlugin.this.reloadMap.keySet().toArray()) + ")";
                        }
                    };
                }
            }
        }
    }

    @OnClassLoadEvent(classNameRegexp="org.eclipse.osgi.internal.loader.EquinoxClassLoader")
    public static void patchEquinoxClassLoader(CtClass ctClass) throws CannotCompileException {
        String registerClassLoader = PluginManagerInvoker.buildCallPluginMethod(OsgiEquinoxPlugin.class, "registerEquinoxClassLoader", "this", "java.lang.Object");
        for (CtConstructor constructor : ctClass.getDeclaredConstructors()) {
            constructor.insertAfter(registerClassLoader);
        }
    }

    public void registerEquinoxClassLoader(Object equinoxClassLoader) {
        LOGGER.debug("RegisterEquinoxClassLoader : " + equinoxClassLoader.getClass().getName(), new Object[0]);
        this.registeredEquinoxClassLoaders.add((ClassLoader)equinoxClassLoader);
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE})
    public void classReload(CtClass ctClass) {
        if (!this.isDebugMode) {
            return;
        }
        try {
            URL url = ctClass.getURL();
            ctClass.writeFile(this.extraClasspath);
            this.loadClassToTargetClassLoaders(ctClass, url.toURI(), false);
        }
        catch (Exception e) {
            LOGGER.warning("classReload() exception : {}", e.getMessage());
        }
    }

    private void scheduleHotswapCommand() {
        this.scheduler.scheduleCommand(this.hotswapCommand, 100, Scheduler.DuplicateSheduleBehaviour.SKIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadClassToTargetClassLoaders(CtClass ctClass, URI uri, boolean putToReloadMap) {
        List<ClassLoader> targetClassLoaders = this.getTargetLoaders(ctClass);
        if (targetClassLoaders == null) {
            LOGGER.trace("Class {} not loaded yet, no need for autoHotswap, skipped file {}", ctClass.getName());
            return false;
        }
        LOGGER.debug("Class {} will be reloaded from URL {}", ctClass.getName(), uri);
        ClassLoader classLoader = null;
        try {
            byte[] bytecode = ctClass.toBytecode();
            for (int i = 0; i < targetClassLoaders.size(); ++i) {
                classLoader = targetClassLoaders.get(i);
                Class<?> clazz = classLoader.loadClass(ctClass.getName());
                if (!putToReloadMap) continue;
                Map<Class<?>, byte[]> map = this.reloadMap;
                synchronized (map) {
                    this.reloadMap.put(clazz, bytecode);
                    continue;
                }
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("OsgiEquinox tries to reload class {}, which is not known to Equinox classLoader {}.", ctClass.getName(), classLoader);
            return false;
        }
        catch (Exception e) {
            LOGGER.warning("loadClassToTargetClassLoaders() exception : {}", e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ClassLoader> getTargetLoaders(CtClass ctClass) {
        ArrayList<ClassLoader> ret = null;
        Set<ClassLoader> set = this.registeredEquinoxClassLoaders;
        synchronized (set) {
            for (ClassLoader classLoader : this.registeredEquinoxClassLoaders) {
                if (!ClassLoaderHelper.isClassLoaded(classLoader, ctClass.getName())) continue;
                if (ret == null) {
                    ret = new ArrayList<ClassLoader>();
                }
                ret.add(classLoader);
            }
        }
        return ret;
    }

    private URL resourceNameToURL(String resource) throws Exception {
        try {
            return new URL(resource);
        }
        catch (MalformedURLException e) {
            if (resource.startsWith("./")) {
                resource = resource.substring(2);
            }
            File file = new File(resource).getCanonicalFile();
            return file.toURI().toURL();
        }
    }

    private static class AutoHotswapPathEventListener
    implements WatchEventListener {
        private OsgiEquinoxPlugin equinoxPlugin;

        public AutoHotswapPathEventListener(OsgiEquinoxPlugin equinoxPlugin) {
            this.equinoxPlugin = equinoxPlugin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(WatchFileEvent event) {
            ClassPool pool = ClassPool.getDefault();
            if (!event.getURI().getPath().endsWith(".class")) {
                return;
            }
            URI fileURI = event.getURI();
            File classFile = new File(fileURI);
            CtClass ctClass = null;
            boolean doHotswap = false;
            try {
                ctClass = pool.makeClass(new FileInputStream(classFile));
                doHotswap = this.equinoxPlugin.loadClassToTargetClassLoaders(ctClass, fileURI, true);
            }
            catch (Exception e) {
                LOGGER.warning("MakeClass exception : {}", e.getMessage());
            }
            finally {
                if (ctClass != null) {
                    ctClass.detach();
                }
            }
            if (doHotswap) {
                this.equinoxPlugin.scheduleHotswapCommand();
            }
        }
    }
}

