/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.owb_jakarta;

import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.owb_jakarta.BeanReloadStrategy;
import org.hotswap.agent.util.signature.ClassSignatureComparerHelper;
import org.hotswap.agent.util.signature.ClassSignatureElement;

public class OwbClassSignatureHelper {
    private static AgentLogger LOGGER = AgentLogger.getLogger(OwbClassSignatureHelper.class);
    private static final ClassSignatureElement[] SIGNATURE_ELEM_PROXY = new ClassSignatureElement[]{ClassSignatureElement.SUPER_CLASS, ClassSignatureElement.INTERFACES, ClassSignatureElement.CLASS_ANNOTATION, ClassSignatureElement.CONSTRUCTOR, ClassSignatureElement.METHOD, ClassSignatureElement.METHOD_ANNOTATION, ClassSignatureElement.METHOD_PARAM_ANNOTATION, ClassSignatureElement.METHOD_EXCEPTION, ClassSignatureElement.FIELD, ClassSignatureElement.FIELD_ANNOTATION};
    private static final ClassSignatureElement[] SIGNATURE_ELEM_METHOD_FIELDS = new ClassSignatureElement[]{ClassSignatureElement.SUPER_CLASS, ClassSignatureElement.INTERFACES, ClassSignatureElement.CLASS_ANNOTATION, ClassSignatureElement.CONSTRUCTOR, ClassSignatureElement.CONSTRUCTOR_PRIVATE, ClassSignatureElement.METHOD, ClassSignatureElement.METHOD_PRIVATE, ClassSignatureElement.METHOD_ANNOTATION, ClassSignatureElement.METHOD_PARAM_ANNOTATION, ClassSignatureElement.FIELD, ClassSignatureElement.FIELD_ANNOTATION};
    private static final ClassSignatureElement[] SIGNATURE_ELEM_FIELDS = new ClassSignatureElement[]{ClassSignatureElement.FIELD, ClassSignatureElement.FIELD_ANNOTATION};

    public static String getSignatureForProxyClass(Class<?> clazz) {
        try {
            return ClassSignatureComparerHelper.getJavaClassSignature(clazz, SIGNATURE_ELEM_PROXY);
        }
        catch (Exception e) {
            LOGGER.error("getSignatureForProxyClass(): Error reading signature", e, new Object[0]);
            return null;
        }
    }

    public static String getSignatureByStrategy(BeanReloadStrategy strategy, Class<?> clazz) {
        if (strategy == null) {
            strategy = BeanReloadStrategy.NEVER;
        }
        switch (strategy) {
            case CLASS_CHANGE: {
                return null;
            }
            case METHOD_FIELD_SIGNATURE_CHANGE: {
                return OwbClassSignatureHelper.getClassMethodFieldsSignature(clazz);
            }
            case FIELD_SIGNATURE_CHANGE: {
                return OwbClassSignatureHelper.getClassFieldsSignature(clazz);
            }
        }
        return null;
    }

    private static String getClassMethodFieldsSignature(Class<?> clazz) {
        try {
            return ClassSignatureComparerHelper.getJavaClassSignature(clazz, SIGNATURE_ELEM_METHOD_FIELDS);
        }
        catch (Exception e) {
            LOGGER.error("getSignatureForProxyClass(): Error reading signature", e, new Object[0]);
            return null;
        }
    }

    private static String getClassFieldsSignature(Class<?> clazz) {
        try {
            return ClassSignatureComparerHelper.getJavaClassSignature(clazz, SIGNATURE_ELEM_FIELDS);
        }
        catch (Exception e) {
            LOGGER.error("getSignatureForProxyClass(): Error reading signature", e, new Object[0]);
            return null;
        }
    }
}

