/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy;

import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hotswap.agent.annotation.LoadEvent;
import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.annotation.Plugin;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.ProxyClassSignatureHelper;
import org.hotswap.agent.plugin.proxy.RedefinitionScheduler;
import org.hotswap.agent.plugin.proxy.ReloadJavaProxyCommand;
import org.hotswap.agent.plugin.proxy.hscglib.CglibEnhancerProxyTransformer;
import org.hotswap.agent.plugin.proxy.hscglib.CglibProxyTransformer;
import org.hotswap.agent.plugin.proxy.hscglib.GeneratorParametersTransformer;
import org.hotswap.agent.plugin.proxy.hscglib.GeneratorParams;
import org.hotswap.agent.util.ReflectionHelper;
import org.hotswap.agent.util.classloader.ClassLoaderHelper;
import org.hotswap.agent.watch.WatcherFactory;

@Plugin(name="Proxy", description="Redefines proxies", testedVersions={""}, expectedVersions={"all"}, supportClass={RedefinitionScheduler.class})
public class ProxyPlugin {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ProxyPlugin.class);
    static boolean isJava8OrNewer = WatcherFactory.JAVA_VERSION >= 18.0;
    public static boolean reloadFlag = false;
    private static Set<String> proxyRedefiningMap = ConcurrentHashMap.newKeySet();

    @OnClassLoadEvent(classNameRegexp="(jdk.proxy\\d+.\\$Proxy.*)|(com.sun.proxy.\\$Proxy.*)", events={LoadEvent.REDEFINE}, skipSynthetic=false)
    public static void transformJavaProxy(Class<?> classBeingRedefined, ClassLoader classLoader) {
        Object proxyCache = ReflectionHelper.getNoException(null, Proxy.class, "proxyCache");
        if (proxyCache != null) {
            try {
                ReflectionHelper.invoke(proxyCache, proxyCache.getClass().getSuperclass(), "removeAll", new Class[]{ClassLoader.class}, classLoader);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Reflection proxy cache flush failed. {}", e.getMessage());
            }
        }
        if (!ClassLoaderHelper.isClassLoderStarted(classLoader)) {
            return;
        }
        String className = classBeingRedefined.getName();
        if (proxyRedefiningMap.contains(className)) {
            proxyRedefiningMap.remove(className);
            return;
        }
        proxyRedefiningMap.add(className);
        Map<String, String> signatureMapOrig = ProxyClassSignatureHelper.getNonSyntheticSignatureMap(classBeingRedefined);
        reloadFlag = true;
        PluginManager.getInstance().getScheduler().scheduleCommand(new ReloadJavaProxyCommand(classLoader, className, signatureMapOrig), 50);
    }

    public static void removeProxyDefiningClassName(String className) {
        proxyRedefiningMap.remove(className);
    }

    @OnClassLoadEvent(classNameRegexp=".*", events={LoadEvent.REDEFINE}, skipSynthetic=false)
    public static byte[] transformCglibProxy(Class<?> classBeingRedefined, byte[] classfileBuffer, ClassLoader loader, ClassPool cp) throws Exception {
        GeneratorParams generatorParams = GeneratorParametersTransformer.getGeneratorParams(loader, classBeingRedefined.getName());
        if (generatorParams == null) {
            return classfileBuffer;
        }
        if (!ClassLoaderHelper.isClassLoderStarted(loader)) {
            return classfileBuffer;
        }
        loader.loadClass("java.beans.Introspector").getMethod("flushCaches", new Class[0]).invoke(null, new Object[0]);
        if (generatorParams.getParam().getClass().getName().endsWith(".Enhancer")) {
            try {
                return CglibEnhancerProxyTransformer.transform(classBeingRedefined, cp, classfileBuffer, loader, generatorParams);
            }
            catch (Exception e) {
                LOGGER.error("Error redifining Cglib Enhancer proxy {}", e, classBeingRedefined.getName());
            }
        }
        if (!isJava8OrNewer) {
            try {
                return CglibProxyTransformer.transform(classBeingRedefined, cp, classfileBuffer, generatorParams);
            }
            catch (Exception e) {
                LOGGER.error("Error redifining Cglib proxy {}", e, classBeingRedefined.getName());
            }
        }
        return classfileBuffer;
    }

    @OnClassLoadEvent(classNameRegexp=".*/cglib/.*", skipSynthetic=false)
    public static CtClass transformDefinitions(CtClass cc) throws Exception {
        try {
            return GeneratorParametersTransformer.transform(cc);
        }
        catch (Exception e) {
            LOGGER.error("Error modifying class for cglib proxy creation parameter recording", e, new Object[0]);
            return cc;
        }
    }
}

