/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.hscglib;

import java.io.IOException;
import java.io.InputStream;
import org.hotswap.agent.plugin.proxy.ProxyTransformationUtils;

public class ParentLastClassLoader
extends ClassLoader {
    public static final String[] EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};

    public ParentLastClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String excludedPackage : EXCLUDED_PACKAGES) {
            if (!name.startsWith(excludedPackage)) continue;
            return super.loadClass(name, resolve);
        }
        Class<?> clazz = this.loadClassFromThisClassLoader(name);
        if (clazz == null) {
            return super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class<?> loadClassFromThisClassLoader(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        byte[] bytes = this.readClass(name);
        if (bytes != null) {
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        return null;
    }

    protected byte[] readClass(String name) throws ClassNotFoundException {
        InputStream is = this.getParent().getResourceAsStream(name.replace('.', '/') + ".class");
        if (is == null) {
            return null;
        }
        try {
            return ProxyTransformationUtils.copyToByteArray(is);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Could not read: " + name, ex);
        }
    }
}

