/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.boot.listener;

import java.util.Objects;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.files.PropertiesChangeEvent;
import org.hotswap.agent.plugin.spring.listener.SpringEvent;
import org.hotswap.agent.plugin.spring.listener.SpringEventSource;
import org.hotswap.agent.plugin.spring.listener.SpringListener;
import org.hotswap.agent.plugin.spring.reload.BeanChangeEvent;
import org.hotswap.agent.util.AnnotationHelper;
import org.hotswap.agent.util.spring.util.ClassUtils;
import org.hotswap.agent.util.spring.util.ObjectUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;

public class PropertySourceChangeListener
implements SpringListener<SpringEvent<?>> {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(PropertySourceChangeListener.class);
    private final DefaultListableBeanFactory beanFactory;

    public static void register(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = context.getBeanFactory();
        if (!(configurableListableBeanFactory instanceof DefaultListableBeanFactory)) {
            LOGGER.debug("beanFactory is not DefaultListableBeanFactory, skip register PropertySourceChangeBootListener, {}", ObjectUtils.identityToString(configurableListableBeanFactory));
            return;
        }
        LOGGER.debug("register PropertySourceChangeBootListener, {}", ObjectUtils.identityToString(configurableListableBeanFactory));
        PropertySourceChangeListener propertySourceChangeListener = new PropertySourceChangeListener((DefaultListableBeanFactory)configurableListableBeanFactory);
        SpringEventSource.INSTANCE.addListener(propertySourceChangeListener);
    }

    public PropertySourceChangeListener(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public DefaultListableBeanFactory beanFactory() {
        return this.beanFactory;
    }

    @Override
    public void onEvent(SpringEvent<?> event) {
        if (event instanceof PropertiesChangeEvent) {
            this.refreshConfigurationProperties(event.getBeanFactory());
        }
    }

    private void refreshConfigurationProperties(ConfigurableListableBeanFactory eventBeanFactory) {
        for (String singleton : this.beanFactory.getSingletonNames()) {
            Object bean = this.beanFactory.getSingleton(singleton);
            Class<?> beanClass = ClassUtils.getUserClass(bean.getClass());
            if (!AnnotationHelper.hasAnnotation(beanClass, ConfigurationProperties.class.getName())) continue;
            LOGGER.debug("refresh configuration properties: {}", beanClass);
            String[] beanNames = this.beanFactory.getBeanNamesForType(beanClass);
            if (beanNames == null || beanNames.length <= 0) continue;
            SpringEventSource.INSTANCE.fireEvent(new BeanChangeEvent(beanNames, eventBeanFactory));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PropertySourceChangeListener)) {
            return false;
        }
        PropertySourceChangeListener that = (PropertySourceChangeListener)o;
        return Objects.equals(this.beanFactory, that.beanFactory);
    }

    public int hashCode() {
        return Objects.hash(this.beanFactory);
    }
}

