/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.core;

import java.util.Map;
import org.hotswap.agent.logging.AgentLogger;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class AutowiredAnnotationProcessor {
    private static AgentLogger LOGGER = AgentLogger.getLogger(AutowiredAnnotationProcessor.class);

    public static void processSingletonBeanInjection(DefaultListableBeanFactory beanFactory) {
        try {
            Map postProcessors = beanFactory.getBeansOfType(AutowiredAnnotationBeanPostProcessor.class);
            if (postProcessors.isEmpty()) {
                LOGGER.debug("AutowiredAnnotationProcessor not exist", new Object[0]);
                return;
            }
            AutowiredAnnotationBeanPostProcessor postProcessor = (AutowiredAnnotationBeanPostProcessor)postProcessors.values().iterator().next();
            boolean postProcessPropertyValuesNotExists = false;
            for (String beanName : beanFactory.getBeanDefinitionNames()) {
                Object object = beanFactory.getSingleton(beanName);
                if (object == null) continue;
                if (postProcessPropertyValuesNotExists) {
                    postProcessor.postProcessProperties(null, object, beanName);
                    continue;
                }
                try {
                    postProcessor.postProcessPropertyValues(null, null, object, beanName);
                }
                catch (NoSuchMethodError e) {
                    postProcessor.postProcessProperties(null, object, beanName);
                    postProcessPropertyValuesNotExists = true;
                }
            }
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("AutowiredAnnotationProcessor maybe not exist", e, new Object[0]);
            }
            LOGGER.warning("AutowiredAnnotationProcessor maybe not exist : " + e.getMessage(), new Object[0]);
        }
    }
}

