/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.ReflectionHelper;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;

public class ResetBeanPostProcessorCaches {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(ResetBeanPostProcessorCaches.class);

    private static Class<?> getReflectionUtilsClassOrNull() {
        try {
            return Class.forName("org.springframework.util.ReflectionUtils");
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("Spring 4.1.x or below - ReflectionUtils class not found", new Object[0]);
            return null;
        }
    }

    public static void reset(DefaultListableBeanFactory beanFactory) {
        block7: {
            Class<?> c = ResetBeanPostProcessorCaches.getReflectionUtilsClassOrNull();
            if (c != null) {
                try {
                    Method m = c.getDeclaredMethod("clearCache", new Class[0]);
                    m.invoke(null, new Object[0]);
                    LOGGER.trace("Cleared Spring 4.2+ internal method/field cache.", new Object[0]);
                }
                catch (Exception version42Failed) {
                    Object declaredFieldsCache1;
                    LOGGER.debug("Failed to clear internal method/field cache, it's normal with spring 4.1.x or lower", version42Failed, new Object[0]);
                    Object declaredMethodsCache = ReflectionHelper.getNoException(null, c, "declaredMethodsCache");
                    if (declaredMethodsCache != null) {
                        ((Map)declaredMethodsCache).clear();
                    }
                    if ((declaredFieldsCache1 = ReflectionHelper.getNoException(null, c, "declaredFieldsCache")) == null) break block7;
                    ((Map)declaredFieldsCache1).clear();
                }
            }
        }
        for (BeanPostProcessor bpp : beanFactory.getBeanPostProcessors()) {
            if (bpp instanceof AutowiredAnnotationBeanPostProcessor) {
                ResetBeanPostProcessorCaches.resetAutowiredAnnotationBeanPostProcessorCache((AutowiredAnnotationBeanPostProcessor)bpp);
                continue;
            }
            if (bpp instanceof CommonAnnotationBeanPostProcessor) {
                ResetBeanPostProcessorCaches.resetAnnotationBeanPostProcessorCache(bpp, CommonAnnotationBeanPostProcessor.class);
                continue;
            }
            if (!(bpp instanceof InitDestroyAnnotationBeanPostProcessor)) continue;
            ResetBeanPostProcessorCaches.resetInitDestroyAnnotationBeanPostProcessorCache((InitDestroyAnnotationBeanPostProcessor)bpp);
        }
    }

    public static void resetInitDestroyAnnotationBeanPostProcessorCache(InitDestroyAnnotationBeanPostProcessor bpp) {
        try {
            Field field = InitDestroyAnnotationBeanPostProcessor.class.getDeclaredField("lifecycleMetadataCache");
            field.setAccessible(true);
            Map lifecycleMetadataCache = (Map)field.get(bpp);
            lifecycleMetadataCache.clear();
            LOGGER.trace("Cache cleared: InitDestroyAnnotationBeanPostProcessor.lifecycleMetadataCache", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear InitDestroyAnnotationBeanPostProcessor.lifecycleMetadataCache", e);
        }
    }

    public static void resetAutowiredAnnotationBeanPostProcessorCache(AutowiredAnnotationBeanPostProcessor bpp) {
        try {
            Field field = AutowiredAnnotationBeanPostProcessor.class.getDeclaredField("candidateConstructorsCache");
            field.setAccessible(true);
            Map candidateConstructorsCache = (Map)field.get(bpp);
            candidateConstructorsCache.clear();
            LOGGER.trace("Cache cleared: AutowiredAnnotationBeanPostProcessor.candidateConstructorsCache", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear AutowiredAnnotationBeanPostProcessor.candidateConstructorsCache", e);
        }
        ResetBeanPostProcessorCaches.resetAnnotationBeanPostProcessorCache(bpp, AutowiredAnnotationBeanPostProcessor.class);
    }

    private static void resetAnnotationBeanPostProcessorCache(Object object, Class<?> clazz) {
        try {
            Field field = clazz.getDeclaredField("injectionMetadataCache");
            field.setAccessible(true);
            Map injectionMetadataCache = (Map)field.get(object);
            injectionMetadataCache.clear();
            LOGGER.trace("Cache cleared: AutowiredAnnotationBeanPostProcessor/CommonAnnotationBeanPostProcessor injectionMetadataCache", new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear AutowiredAnnotationBeanPostProcessor/CommonAnnotationBeanPostProcessor injectionMetadataCache", e);
        }
    }
}

