/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.hotswap.agent.logging.AgentLogger;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ResetRequestMappingCaches {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ResetRequestMappingCaches.class);

    private static Class<?> getHandlerMethodMappingClassOrNull() {
        try {
            return Class.forName("org.springframework.web.servlet.handler.AbstractHandlerMethodMapping");
        }
        catch (ClassNotFoundException e) {
            LOGGER.trace("HandlerMethodMapping class not found", new Object[0]);
            return null;
        }
    }

    public static void reset(DefaultListableBeanFactory beanFactory) {
        Class<?> c = ResetRequestMappingCaches.getHandlerMethodMappingClassOrNull();
        if (c == null) {
            return;
        }
        Map mappings = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, c, (boolean)true, (boolean)false);
        if (mappings.isEmpty()) {
            LOGGER.trace("Spring: no HandlerMappings found", new Object[0]);
        }
        try {
            for (Map.Entry e : mappings.entrySet()) {
                Object am = e.getValue();
                LOGGER.trace("Spring: clearing HandlerMapping for {}", am.getClass());
                try {
                    Field f = c.getDeclaredField("handlerMethods");
                    f.setAccessible(true);
                    ((Map)f.get(am)).clear();
                    f = c.getDeclaredField("urlMap");
                    f.setAccessible(true);
                    ((Map)f.get(am)).clear();
                    try {
                        f = c.getDeclaredField("nameMap");
                        f.setAccessible(true);
                        ((Map)f.get(am)).clear();
                    }
                    catch (NoSuchFieldException nsfe) {
                        LOGGER.trace("Probably using Spring 4.0 or below: {}", nsfe.getMessage());
                    }
                }
                catch (NoSuchFieldException nsfe) {
                    LOGGER.trace("Probably using Spring 4.2+", nsfe.getMessage());
                    Method m = c.getDeclaredMethod("getHandlerMethods", new Class[0]);
                    Class[] parameterTypes = new Class[]{Object.class};
                    Method u = c.getDeclaredMethod("unregisterMapping", parameterTypes);
                    Map unmodifiableHandlerMethods = (Map)m.invoke(am, new Object[0]);
                    Object[] keys = unmodifiableHandlerMethods.keySet().toArray();
                    unmodifiableHandlerMethods = null;
                    for (Object key : keys) {
                        LOGGER.trace("Unregistering handler method {}", key);
                        u.invoke(am, key);
                    }
                }
                if (!(am instanceof InitializingBean)) continue;
                ((InitializingBean)am).afterPropertiesSet();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to clear HandlerMappings", e, new Object[0]);
        }
    }
}

