/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.getbean;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.getbean.SpringHotswapAgentProxy;

public class DetachableBeanHolder
implements Serializable {
    private static final long serialVersionUID = -7443802320153815102L;
    private Object bean;
    private Object beanFactory;
    private Class<?>[] paramClasses;
    private Object[] paramValues;
    private static List<WeakReference<DetachableBeanHolder>> beanProxies = Collections.synchronizedList(new ArrayList());
    private static AgentLogger LOGGER = AgentLogger.getLogger(DetachableBeanHolder.class);

    public DetachableBeanHolder(Object bean, Object beanFactry, Class<?>[] paramClasses, Object[] paramValues) {
        if (bean == null) {
            LOGGER.error("Bean is null. The param value: {}", Arrays.toString(paramValues));
        }
        this.bean = bean;
        this.beanFactory = beanFactry;
        this.paramClasses = paramClasses;
        this.paramValues = paramValues;
        beanProxies.add(new WeakReference<DetachableBeanHolder>(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachBeans() {
        int i = 0;
        List<WeakReference<DetachableBeanHolder>> list = beanProxies;
        synchronized (list) {
            while (i < beanProxies.size()) {
                DetachableBeanHolder beanHolder = (DetachableBeanHolder)beanProxies.get(i).get();
                if (beanHolder != null) {
                    beanHolder.detach();
                    ++i;
                    continue;
                }
                beanProxies.remove(i);
            }
        }
        if (i > 0) {
            LOGGER.debug("{} Spring proxies reset", i);
        } else {
            LOGGER.debug("No spring proxies reset", new Object[0]);
        }
    }

    public void detach() {
        this.bean = null;
    }

    public void setTarget(Object bean) {
        this.bean = bean;
    }

    public Object getTarget() {
        return this.bean;
    }

    public Object getBean() throws IllegalAccessException, InvocationTargetException {
        Object beanCopy = this.bean;
        if (beanCopy == null) {
            Method[] methods;
            for (Method factoryMethod : methods = this.beanFactory.getClass().getMethods()) {
                if (!"getBean".equals(factoryMethod.getName()) || !Arrays.equals(factoryMethod.getParameterTypes(), this.paramClasses)) continue;
                Object freshBean = factoryMethod.invoke(this.beanFactory, this.paramValues);
                if (freshBean instanceof SpringHotswapAgentProxy) {
                    freshBean = ((SpringHotswapAgentProxy)freshBean).$$ha$getTarget();
                }
                if ((beanCopy = (this.bean = freshBean)) == null) {
                    LOGGER.debug("Bean of '{}' not loaded, {} ", this.bean.getClass().getName(), this.paramValues);
                    break;
                }
                LOGGER.debug("Bean '{}' loaded", this.bean.getClass().getName());
                break;
            }
        }
        return beanCopy;
    }

    protected boolean isBeanLoaded() {
        return this.bean != null;
    }
}

