/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.listener;

import java.util.HashSet;
import java.util.Set;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.listener.SpringEvent;
import org.hotswap.agent.plugin.spring.listener.SpringListener;

public class SpringEventSource {
    private static final AgentLogger LOGGER = AgentLogger.getLogger(SpringEventSource.class);
    public static final SpringEventSource INSTANCE = new SpringEventSource();
    private final Set<SpringListener<SpringEvent<?>>> listeners = new HashSet();

    private SpringEventSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SpringListener<SpringEvent<?>> listener) {
        if (listener == null) {
            return;
        }
        Set<SpringListener<SpringEvent<?>>> set = this.listeners;
        synchronized (set) {
            if (this.listeners.contains(listener)) {
                LOGGER.debug("SpringListener already registered, {}", listener);
                return;
            }
            this.listeners.add(listener);
        }
    }

    public void fireEvent(SpringEvent<?> event) {
        for (SpringListener<SpringEvent<?>> listener : this.listeners) {
            if (listener.shouldSkip(event)) continue;
            try {
                listener.onEvent(event);
            }
            catch (Throwable e) {
                LOGGER.warning("SpringListener onEvent error", e, new Object[0]);
            }
        }
    }
}

