/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.listener;

import java.util.EventListener;
import org.hotswap.agent.plugin.spring.listener.SpringEvent;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public interface SpringListener<E extends SpringEvent<?>>
extends EventListener {
    public DefaultListableBeanFactory beanFactory();

    public void onEvent(E var1);

    default public boolean shouldSkip(E event) {
        return !SpringListener.isParentOrSelf((ConfigurableListableBeanFactory)this.beanFactory(), ((SpringEvent)event).getBeanFactory());
    }

    public static boolean isParentOrSelf(ConfigurableListableBeanFactory beanFactory, ConfigurableListableBeanFactory sourceBeanFactory) {
        if (beanFactory == null) {
            return false;
        }
        if (sourceBeanFactory == beanFactory) {
            return true;
        }
        if (sourceBeanFactory.getParentBeanFactory() == null) {
            return false;
        }
        if (sourceBeanFactory.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
            return SpringListener.isParentOrSelf(beanFactory, (ConfigurableListableBeanFactory)sourceBeanFactory.getParentBeanFactory());
        }
        return false;
    }

    default public int priority() {
        return 10000;
    }
}

