/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.spring.reload;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.spring.listener.SpringEvent;
import org.hotswap.agent.plugin.spring.listener.SpringEventSource;
import org.hotswap.agent.plugin.spring.listener.SpringListener;
import org.hotswap.agent.plugin.spring.reload.BeanChangeEvent;
import org.hotswap.agent.plugin.spring.reload.SpringBeanReload;
import org.hotswap.agent.plugin.spring.scanner.BeanDefinitionChangeEvent;
import org.hotswap.agent.util.spring.util.ObjectUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class SpringChangedAgent
implements SpringListener<SpringEvent<?>>,
Comparable<SpringChangedAgent> {
    private static AgentLogger LOGGER = AgentLogger.getLogger(SpringChangedAgent.class);
    private static final AtomicInteger waitingReloadCount = new AtomicInteger(0);
    private DefaultListableBeanFactory defaultListableBeanFactory;
    private static ClassLoader appClassLoader;
    private static Map<DefaultListableBeanFactory, SpringChangedAgent> springChangeAgents;
    private final SpringBeanReload springReload;
    ReentrantLock reloadLock = new ReentrantLock();

    public SpringChangedAgent(DefaultListableBeanFactory defaultListableBeanFactory) {
        this.springReload = new SpringBeanReload(defaultListableBeanFactory);
        this.defaultListableBeanFactory = defaultListableBeanFactory;
        SpringEventSource.INSTANCE.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpringChangedAgent getInstance(DefaultListableBeanFactory beanFactory) {
        if (springChangeAgents.get(beanFactory) != null) return springChangeAgents.get(beanFactory);
        Class<SpringChangedAgent> clazz = SpringChangedAgent.class;
        synchronized (SpringChangedAgent.class) {
            if (springChangeAgents.get(beanFactory) != null) return springChangeAgents.get(beanFactory);
            SpringChangedAgent springChangedAgent = new SpringChangedAgent(beanFactory);
            springChangeAgents.put(beanFactory, springChangedAgent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return springChangeAgents.get(beanFactory);
        }
    }

    public static void setClassLoader(ClassLoader classLoader) {
        appClassLoader = classLoader;
    }

    public static boolean addChangedClass(Class clazz) {
        boolean result = false;
        for (SpringChangedAgent springChangedAgent : springChangeAgents.values()) {
            result |= springChangedAgent.addClass(clazz);
        }
        return result;
    }

    public static boolean addChangedClass(Class clazz, DefaultListableBeanFactory beanFactory) {
        boolean result = false;
        for (SpringChangedAgent springChangedAgent : springChangeAgents.values()) {
            if (springChangedAgent.beanFactory() != beanFactory) continue;
            result |= springChangedAgent.addClass(clazz);
        }
        return result;
    }

    public static boolean addChangedXml(URL xmlUrl) {
        for (SpringChangedAgent springChangedAgent : springChangeAgents.values()) {
            springChangedAgent.addXml(xmlUrl);
        }
        return true;
    }

    public static boolean addChangedProperty(URL property) {
        for (SpringChangedAgent springChangedAgent : springChangeAgents.values()) {
            springChangedAgent.addProperty(property);
        }
        return true;
    }

    public static boolean addChangedYaml(URL yamlProperty) {
        for (SpringChangedAgent springChangedAgent : springChangeAgents.values()) {
            springChangedAgent.addYaml(yamlProperty);
        }
        return true;
    }

    public static boolean addNewBean(BeanDefinitionHolder beanDefinitionHolder, ConfigurableListableBeanFactory beanFactory) {
        for (SpringChangedAgent springChangedAgent : springChangeAgents.values()) {
            if (springChangedAgent.beanFactory() != beanFactory) continue;
            springChangedAgent.addNewBean((BeanDefinitionRegistry)springChangedAgent.beanFactory(), beanDefinitionHolder);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload(long changeTimeStamps) {
        int reloadCount = waitingReloadCount.incrementAndGet();
        if (reloadCount > 2) {
            LOGGER.trace("Spring reload is already scheduled, skip this time:{}", changeTimeStamps);
            waitingReloadCount.decrementAndGet();
            return;
        }
        try {
            ArrayList<SpringChangedAgent> changedAgentList = new ArrayList<SpringChangedAgent>(springChangeAgents.values());
            Collections.sort(changedAgentList);
            for (SpringChangedAgent springChangedAgent : changedAgentList) {
                springChangedAgent.reloadAll(changeTimeStamps);
            }
        }
        finally {
            waitingReloadCount.decrementAndGet();
        }
    }

    public static void destroyBeanFactory(AbstractAutowireCapableBeanFactory beanFactory) {
        if (!(beanFactory instanceof DefaultListableBeanFactory)) {
            return;
        }
        springChangeAgents.remove(beanFactory);
    }

    boolean addClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        this.springReload.addClass(clazz);
        return true;
    }

    void addProperty(URL property) {
        this.springReload.addProperty(property);
    }

    void addYaml(URL yaml) {
        this.springReload.addYaml(yaml);
    }

    void addXml(URL xml) {
        this.springReload.addXml(xml);
    }

    void addChangedBeanNames(String[] beanNames) {
        this.springReload.addChangedBeanNames(beanNames);
    }

    void addNewBean(BeanDefinitionRegistry registry, BeanDefinitionHolder beanDefinitionHolder) {
        this.springReload.addScanNewBean(registry, beanDefinitionHolder);
    }

    private void reloadAll(long changeTimeStamps) {
        try {
            this.doReload(changeTimeStamps);
        }
        catch (InterruptedException e) {
            LOGGER.warning("reload spring failed: {}", e, ObjectUtils.identityToString(this.defaultListableBeanFactory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReload(long changeTimeStamps) throws InterruptedException {
        boolean isLockAcquired = this.reloadLock.tryLock(1L, TimeUnit.SECONDS);
        if (isLockAcquired) {
            try {
                LOGGER.trace("Spring reload: {} at timestamps '{}'", ObjectUtils.identityToString(this.defaultListableBeanFactory), changeTimeStamps);
                this.springReload.reload(changeTimeStamps);
            }
            finally {
                this.reloadLock.unlock();
            }
        } else {
            Thread.sleep(100L);
            this.doReload(changeTimeStamps);
        }
    }

    public static void collectPlaceholderProperties(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        if (!(configurableListableBeanFactory instanceof DefaultListableBeanFactory)) {
            return;
        }
        SpringChangedAgent.getInstance((DefaultListableBeanFactory)((DefaultListableBeanFactory)configurableListableBeanFactory)).springReload.collectPlaceHolderProperties();
    }

    @Override
    public DefaultListableBeanFactory beanFactory() {
        return this.defaultListableBeanFactory;
    }

    @Override
    public void onEvent(SpringEvent<?> event) {
        if (event instanceof BeanDefinitionChangeEvent) {
            BeanDefinitionChangeEvent beanDefinitionChangeEvent = (BeanDefinitionChangeEvent)event;
            this.addNewBean((BeanDefinitionRegistry)this.beanFactory(), (BeanDefinitionHolder)beanDefinitionChangeEvent.getSource());
        } else if (event instanceof BeanChangeEvent) {
            BeanChangeEvent beanChangeEvent = (BeanChangeEvent)event;
            this.addChangedBeanNames((String[])beanChangeEvent.getSource());
        }
    }

    private int orderByParentBeanFactory(AbstractBeanFactory beanFactory) {
        if (beanFactory == null) {
            return 0;
        }
        if (beanFactory.getParentBeanFactory() == null) {
            return 1;
        }
        if (beanFactory.getParentBeanFactory() instanceof AbstractBeanFactory) {
            return 1 + this.orderByParentBeanFactory((AbstractBeanFactory)beanFactory.getParentBeanFactory());
        }
        return 1;
    }

    @Override
    public int compareTo(SpringChangedAgent o) {
        return Integer.compare(this.orderByParentBeanFactory((AbstractBeanFactory)this.defaultListableBeanFactory), this.orderByParentBeanFactory((AbstractBeanFactory)o.defaultListableBeanFactory));
    }

    static {
        springChangeAgents = new ConcurrentHashMap<DefaultListableBeanFactory, SpringChangedAgent>(2);
    }
}

